/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.SnapshotFile;
import com.amazonaws.services.quicksight.model.transform.SnapshotFileGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SnapshotFileGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SnapshotFile> files;

    public List<SnapshotFile> getFiles() {
        return this.files;
    }

    public void setFiles(Collection<SnapshotFile> files) {
        if (files == null) {
            this.files = null;
            return;
        }
        this.files = new ArrayList<SnapshotFile>(files);
    }

    public SnapshotFileGroup withFiles(SnapshotFile ... files) {
        if (this.files == null) {
            this.setFiles(new ArrayList<SnapshotFile>(files.length));
        }
        for (SnapshotFile ele : files) {
            this.files.add(ele);
        }
        return this;
    }

    public SnapshotFileGroup withFiles(Collection<SnapshotFile> files) {
        this.setFiles(files);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFiles() != null) {
            sb.append("Files: ").append(this.getFiles());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotFileGroup)) {
            return false;
        }
        SnapshotFileGroup other = (SnapshotFileGroup)obj;
        if (other.getFiles() == null ^ this.getFiles() == null) {
            return false;
        }
        return other.getFiles() == null || other.getFiles().equals(this.getFiles());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFiles() == null ? 0 : this.getFiles().hashCode());
        return hashCode;
    }

    public SnapshotFileGroup clone() {
        try {
            return (SnapshotFileGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnapshotFileGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

