/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ram.model.ResourceShare;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ResourceShareMarshaller {
    private static final MarshallingInfo<String> RESOURCESHAREARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceShareArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> OWNINGACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("owningAccountId").build();
    private static final MarshallingInfo<Boolean> ALLOWEXTERNALPRINCIPALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowExternalPrincipals").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusMessage").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FEATURESET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("featureSet").build();
    private static final ResourceShareMarshaller instance = new ResourceShareMarshaller();

    public static ResourceShareMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceShare resourceShare, ProtocolMarshaller protocolMarshaller) {
        if (resourceShare == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceShare.getResourceShareArn(), RESOURCESHAREARN_BINDING);
            protocolMarshaller.marshall((Object)resourceShare.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)resourceShare.getOwningAccountId(), OWNINGACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)resourceShare.getAllowExternalPrincipals(), ALLOWEXTERNALPRINCIPALS_BINDING);
            protocolMarshaller.marshall((Object)resourceShare.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)resourceShare.getStatusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall(resourceShare.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)resourceShare.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)resourceShare.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)resourceShare.getFeatureSet(), FEATURESET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

