/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ram.model;

import javax.annotation.Generated;

/**
 * <p>
 * There isn't an existing managed permission defined in RAM that has the same IAM permissions as the resource-based
 * policy attached to the resource. You should first run <a>PromotePermissionCreatedFromPolicy</a> to create that
 * managed permission.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UnmatchedPolicyPermissionException extends com.amazonaws.services.ram.model.AWSRAMException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new UnmatchedPolicyPermissionException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public UnmatchedPolicyPermissionException(String message) {
        super(message);
    }

}
