/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RestoreDBClusterToPointInTimeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBClusterIdentifier;
    private String sourceDBClusterIdentifier;
    private Date restoreToTime;
    private Boolean useLatestRestorableTime;
    private Integer port;
    private String dBSubnetGroupName;
    private String optionGroupName;
    private ListWithAutoConstructFlag<String> vpcSecurityGroupIds;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public RestoreDBClusterToPointInTimeRequest withDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
        return this;
    }

    public String getSourceDBClusterIdentifier() {
        return this.sourceDBClusterIdentifier;
    }

    public void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
        this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
    }

    public RestoreDBClusterToPointInTimeRequest withSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
        this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        return this;
    }

    public Date getRestoreToTime() {
        return this.restoreToTime;
    }

    public void setRestoreToTime(Date restoreToTime) {
        this.restoreToTime = restoreToTime;
    }

    public RestoreDBClusterToPointInTimeRequest withRestoreToTime(Date restoreToTime) {
        this.restoreToTime = restoreToTime;
        return this;
    }

    public Boolean isUseLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
        this.useLatestRestorableTime = useLatestRestorableTime;
    }

    public RestoreDBClusterToPointInTimeRequest withUseLatestRestorableTime(Boolean useLatestRestorableTime) {
        this.useLatestRestorableTime = useLatestRestorableTime;
        return this;
    }

    public Boolean getUseLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public RestoreDBClusterToPointInTimeRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getDBSubnetGroupName() {
        return this.dBSubnetGroupName;
    }

    public void setDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
    }

    public RestoreDBClusterToPointInTimeRequest withDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
        return this;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public RestoreDBClusterToPointInTimeRequest withOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
        return this;
    }

    public List<String> getVpcSecurityGroupIds() {
        if (this.vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = new ListWithAutoConstructFlag();
            this.vpcSecurityGroupIds.setAutoConstruct(true);
        }
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag vpcSecurityGroupIdsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupIds.size());
        vpcSecurityGroupIdsCopy.addAll(vpcSecurityGroupIds);
        this.vpcSecurityGroupIds = vpcSecurityGroupIdsCopy;
    }

    public RestoreDBClusterToPointInTimeRequest withVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
        if (this.getVpcSecurityGroupIds() == null) {
            this.setVpcSecurityGroupIds(new ArrayList<String>(vpcSecurityGroupIds.length));
        }
        for (String value : vpcSecurityGroupIds) {
            this.getVpcSecurityGroupIds().add(value);
        }
        return this;
    }

    public RestoreDBClusterToPointInTimeRequest withVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
        } else {
            ListWithAutoConstructFlag vpcSecurityGroupIdsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupIds.size());
            vpcSecurityGroupIdsCopy.addAll(vpcSecurityGroupIds);
            this.vpcSecurityGroupIds = vpcSecurityGroupIdsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RestoreDBClusterToPointInTimeRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RestoreDBClusterToPointInTimeRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: " + this.getDBClusterIdentifier() + ",");
        }
        if (this.getSourceDBClusterIdentifier() != null) {
            sb.append("SourceDBClusterIdentifier: " + this.getSourceDBClusterIdentifier() + ",");
        }
        if (this.getRestoreToTime() != null) {
            sb.append("RestoreToTime: " + this.getRestoreToTime() + ",");
        }
        if (this.isUseLatestRestorableTime() != null) {
            sb.append("UseLatestRestorableTime: " + this.isUseLatestRestorableTime() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getDBSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: " + this.getDBSubnetGroupName() + ",");
        }
        if (this.getOptionGroupName() != null) {
            sb.append("OptionGroupName: " + this.getOptionGroupName() + ",");
        }
        if (this.getVpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: " + this.getVpcSecurityGroupIds() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDBClusterIdentifier() == null ? 0 : this.getSourceDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getRestoreToTime() == null ? 0 : this.getRestoreToTime().hashCode());
        hashCode = 31 * hashCode + (this.isUseLatestRestorableTime() == null ? 0 : this.isUseLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroupName() == null ? 0 : this.getDBSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupIds() == null ? 0 : this.getVpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDBClusterToPointInTimeRequest)) {
            return false;
        }
        RestoreDBClusterToPointInTimeRequest other = (RestoreDBClusterToPointInTimeRequest)obj;
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getSourceDBClusterIdentifier() == null ^ this.getSourceDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getSourceDBClusterIdentifier() != null && !other.getSourceDBClusterIdentifier().equals(this.getSourceDBClusterIdentifier())) {
            return false;
        }
        if (other.getRestoreToTime() == null ^ this.getRestoreToTime() == null) {
            return false;
        }
        if (other.getRestoreToTime() != null && !other.getRestoreToTime().equals(this.getRestoreToTime())) {
            return false;
        }
        if (other.isUseLatestRestorableTime() == null ^ this.isUseLatestRestorableTime() == null) {
            return false;
        }
        if (other.isUseLatestRestorableTime() != null && !other.isUseLatestRestorableTime().equals(this.isUseLatestRestorableTime())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getDBSubnetGroupName() == null ^ this.getDBSubnetGroupName() == null) {
            return false;
        }
        if (other.getDBSubnetGroupName() != null && !other.getDBSubnetGroupName().equals(this.getDBSubnetGroupName())) {
            return false;
        }
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() == null ^ this.getVpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() != null && !other.getVpcSecurityGroupIds().equals(this.getVpcSecurityGroupIds())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public RestoreDBClusterToPointInTimeRequest clone() {
        return (RestoreDBClusterToPointInTimeRequest)super.clone();
    }
}

