/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateDBProxyRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.services.rds.model.UserAuthConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDBProxyRequestMarshaller
implements Marshaller<Request<CreateDBProxyRequest>, CreateDBProxyRequest> {
    public Request<CreateDBProxyRequest> marshall(CreateDBProxyRequest createDBProxyRequest) {
        if (createDBProxyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBProxyRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBProxy");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBProxyRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)createDBProxyRequest.getDBProxyName()));
        }
        if (createDBProxyRequest.getEngineFamily() != null) {
            request.addParameter("EngineFamily", StringUtils.fromString((String)createDBProxyRequest.getEngineFamily()));
        }
        if (!createDBProxyRequest.getAuth().isEmpty() || !((SdkInternalList)createDBProxyRequest.getAuth()).isAutoConstruct()) {
            SdkInternalList authList = (SdkInternalList)createDBProxyRequest.getAuth();
            int authListIndex = 1;
            for (UserAuthConfig authListValue : authList) {
                if (authListValue != null) {
                    if (authListValue.getDescription() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".Description", StringUtils.fromString((String)authListValue.getDescription()));
                    }
                    if (authListValue.getUserName() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".UserName", StringUtils.fromString((String)authListValue.getUserName()));
                    }
                    if (authListValue.getAuthScheme() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".AuthScheme", StringUtils.fromString((String)authListValue.getAuthScheme()));
                    }
                    if (authListValue.getSecretArn() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".SecretArn", StringUtils.fromString((String)authListValue.getSecretArn()));
                    }
                    if (authListValue.getIAMAuth() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".IAMAuth", StringUtils.fromString((String)authListValue.getIAMAuth()));
                    }
                }
                ++authListIndex;
            }
        }
        if (createDBProxyRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)createDBProxyRequest.getRoleArn()));
        }
        if (!createDBProxyRequest.getVpcSubnetIds().isEmpty() || !((SdkInternalList)createDBProxyRequest.getVpcSubnetIds()).isAutoConstruct()) {
            SdkInternalList vpcSubnetIdsList = (SdkInternalList)createDBProxyRequest.getVpcSubnetIds();
            int vpcSubnetIdsListIndex = 1;
            for (String vpcSubnetIdsListValue : vpcSubnetIdsList) {
                if (vpcSubnetIdsListValue != null) {
                    request.addParameter("VpcSubnetIds.member." + vpcSubnetIdsListIndex, StringUtils.fromString((String)vpcSubnetIdsListValue));
                }
                ++vpcSubnetIdsListIndex;
            }
        }
        if (!createDBProxyRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)createDBProxyRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)createDBProxyRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.member." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBProxyRequest.getRequireTLS() != null) {
            request.addParameter("RequireTLS", StringUtils.fromBoolean((Boolean)createDBProxyRequest.getRequireTLS()));
        }
        if (createDBProxyRequest.getIdleClientTimeout() != null) {
            request.addParameter("IdleClientTimeout", StringUtils.fromInteger((Integer)createDBProxyRequest.getIdleClientTimeout()));
        }
        if (createDBProxyRequest.getDebugLogging() != null) {
            request.addParameter("DebugLogging", StringUtils.fromBoolean((Boolean)createDBProxyRequest.getDebugLogging()));
        }
        if (!createDBProxyRequest.getTags().isEmpty() || !((SdkInternalList)createDBProxyRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBProxyRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

