/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CharacterSet;
import com.amazonaws.services.rds.model.Timezone;
import com.amazonaws.services.rds.model.UpgradeTarget;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DBEngineVersion
implements Serializable,
Cloneable {
    private String engine;
    private String engineVersion;
    private String dBParameterGroupFamily;
    private String dBEngineDescription;
    private String dBEngineVersionDescription;
    private CharacterSet defaultCharacterSet;
    private SdkInternalList<CharacterSet> supportedCharacterSets;
    private SdkInternalList<UpgradeTarget> validUpgradeTarget;
    private SdkInternalList<Timezone> supportedTimezones;
    private SdkInternalList<String> exportableLogTypes;
    private Boolean supportsLogExportsToCloudwatchLogs;
    private Boolean supportsReadReplica;
    private SdkInternalList<String> supportedEngineModes;
    private SdkInternalList<String> supportedFeatureNames;

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public DBEngineVersion withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public DBEngineVersion withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setDBParameterGroupFamily(String dBParameterGroupFamily) {
        this.dBParameterGroupFamily = dBParameterGroupFamily;
    }

    public String getDBParameterGroupFamily() {
        return this.dBParameterGroupFamily;
    }

    public DBEngineVersion withDBParameterGroupFamily(String dBParameterGroupFamily) {
        this.setDBParameterGroupFamily(dBParameterGroupFamily);
        return this;
    }

    public void setDBEngineDescription(String dBEngineDescription) {
        this.dBEngineDescription = dBEngineDescription;
    }

    public String getDBEngineDescription() {
        return this.dBEngineDescription;
    }

    public DBEngineVersion withDBEngineDescription(String dBEngineDescription) {
        this.setDBEngineDescription(dBEngineDescription);
        return this;
    }

    public void setDBEngineVersionDescription(String dBEngineVersionDescription) {
        this.dBEngineVersionDescription = dBEngineVersionDescription;
    }

    public String getDBEngineVersionDescription() {
        return this.dBEngineVersionDescription;
    }

    public DBEngineVersion withDBEngineVersionDescription(String dBEngineVersionDescription) {
        this.setDBEngineVersionDescription(dBEngineVersionDescription);
        return this;
    }

    public void setDefaultCharacterSet(CharacterSet defaultCharacterSet) {
        this.defaultCharacterSet = defaultCharacterSet;
    }

    public CharacterSet getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public DBEngineVersion withDefaultCharacterSet(CharacterSet defaultCharacterSet) {
        this.setDefaultCharacterSet(defaultCharacterSet);
        return this;
    }

    public List<CharacterSet> getSupportedCharacterSets() {
        if (this.supportedCharacterSets == null) {
            this.supportedCharacterSets = new SdkInternalList();
        }
        return this.supportedCharacterSets;
    }

    public void setSupportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
        if (supportedCharacterSets == null) {
            this.supportedCharacterSets = null;
            return;
        }
        this.supportedCharacterSets = new SdkInternalList(supportedCharacterSets);
    }

    public DBEngineVersion withSupportedCharacterSets(CharacterSet ... supportedCharacterSets) {
        if (this.supportedCharacterSets == null) {
            this.setSupportedCharacterSets((Collection<CharacterSet>)new SdkInternalList(supportedCharacterSets.length));
        }
        for (CharacterSet ele : supportedCharacterSets) {
            this.supportedCharacterSets.add((Object)ele);
        }
        return this;
    }

    public DBEngineVersion withSupportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
        this.setSupportedCharacterSets(supportedCharacterSets);
        return this;
    }

    public List<UpgradeTarget> getValidUpgradeTarget() {
        if (this.validUpgradeTarget == null) {
            this.validUpgradeTarget = new SdkInternalList();
        }
        return this.validUpgradeTarget;
    }

    public void setValidUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
        if (validUpgradeTarget == null) {
            this.validUpgradeTarget = null;
            return;
        }
        this.validUpgradeTarget = new SdkInternalList(validUpgradeTarget);
    }

    public DBEngineVersion withValidUpgradeTarget(UpgradeTarget ... validUpgradeTarget) {
        if (this.validUpgradeTarget == null) {
            this.setValidUpgradeTarget((Collection<UpgradeTarget>)new SdkInternalList(validUpgradeTarget.length));
        }
        for (UpgradeTarget ele : validUpgradeTarget) {
            this.validUpgradeTarget.add((Object)ele);
        }
        return this;
    }

    public DBEngineVersion withValidUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
        this.setValidUpgradeTarget(validUpgradeTarget);
        return this;
    }

    public List<Timezone> getSupportedTimezones() {
        if (this.supportedTimezones == null) {
            this.supportedTimezones = new SdkInternalList();
        }
        return this.supportedTimezones;
    }

    public void setSupportedTimezones(Collection<Timezone> supportedTimezones) {
        if (supportedTimezones == null) {
            this.supportedTimezones = null;
            return;
        }
        this.supportedTimezones = new SdkInternalList(supportedTimezones);
    }

    public DBEngineVersion withSupportedTimezones(Timezone ... supportedTimezones) {
        if (this.supportedTimezones == null) {
            this.setSupportedTimezones((Collection<Timezone>)new SdkInternalList(supportedTimezones.length));
        }
        for (Timezone ele : supportedTimezones) {
            this.supportedTimezones.add((Object)ele);
        }
        return this;
    }

    public DBEngineVersion withSupportedTimezones(Collection<Timezone> supportedTimezones) {
        this.setSupportedTimezones(supportedTimezones);
        return this;
    }

    public List<String> getExportableLogTypes() {
        if (this.exportableLogTypes == null) {
            this.exportableLogTypes = new SdkInternalList();
        }
        return this.exportableLogTypes;
    }

    public void setExportableLogTypes(Collection<String> exportableLogTypes) {
        if (exportableLogTypes == null) {
            this.exportableLogTypes = null;
            return;
        }
        this.exportableLogTypes = new SdkInternalList(exportableLogTypes);
    }

    public DBEngineVersion withExportableLogTypes(String ... exportableLogTypes) {
        if (this.exportableLogTypes == null) {
            this.setExportableLogTypes((Collection<String>)new SdkInternalList(exportableLogTypes.length));
        }
        for (String ele : exportableLogTypes) {
            this.exportableLogTypes.add((Object)ele);
        }
        return this;
    }

    public DBEngineVersion withExportableLogTypes(Collection<String> exportableLogTypes) {
        this.setExportableLogTypes(exportableLogTypes);
        return this;
    }

    public void setSupportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
        this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
    }

    public Boolean getSupportsLogExportsToCloudwatchLogs() {
        return this.supportsLogExportsToCloudwatchLogs;
    }

    public DBEngineVersion withSupportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
        this.setSupportsLogExportsToCloudwatchLogs(supportsLogExportsToCloudwatchLogs);
        return this;
    }

    public Boolean isSupportsLogExportsToCloudwatchLogs() {
        return this.supportsLogExportsToCloudwatchLogs;
    }

    public void setSupportsReadReplica(Boolean supportsReadReplica) {
        this.supportsReadReplica = supportsReadReplica;
    }

    public Boolean getSupportsReadReplica() {
        return this.supportsReadReplica;
    }

    public DBEngineVersion withSupportsReadReplica(Boolean supportsReadReplica) {
        this.setSupportsReadReplica(supportsReadReplica);
        return this;
    }

    public Boolean isSupportsReadReplica() {
        return this.supportsReadReplica;
    }

    public List<String> getSupportedEngineModes() {
        if (this.supportedEngineModes == null) {
            this.supportedEngineModes = new SdkInternalList();
        }
        return this.supportedEngineModes;
    }

    public void setSupportedEngineModes(Collection<String> supportedEngineModes) {
        if (supportedEngineModes == null) {
            this.supportedEngineModes = null;
            return;
        }
        this.supportedEngineModes = new SdkInternalList(supportedEngineModes);
    }

    public DBEngineVersion withSupportedEngineModes(String ... supportedEngineModes) {
        if (this.supportedEngineModes == null) {
            this.setSupportedEngineModes((Collection<String>)new SdkInternalList(supportedEngineModes.length));
        }
        for (String ele : supportedEngineModes) {
            this.supportedEngineModes.add((Object)ele);
        }
        return this;
    }

    public DBEngineVersion withSupportedEngineModes(Collection<String> supportedEngineModes) {
        this.setSupportedEngineModes(supportedEngineModes);
        return this;
    }

    public List<String> getSupportedFeatureNames() {
        if (this.supportedFeatureNames == null) {
            this.supportedFeatureNames = new SdkInternalList();
        }
        return this.supportedFeatureNames;
    }

    public void setSupportedFeatureNames(Collection<String> supportedFeatureNames) {
        if (supportedFeatureNames == null) {
            this.supportedFeatureNames = null;
            return;
        }
        this.supportedFeatureNames = new SdkInternalList(supportedFeatureNames);
    }

    public DBEngineVersion withSupportedFeatureNames(String ... supportedFeatureNames) {
        if (this.supportedFeatureNames == null) {
            this.setSupportedFeatureNames((Collection<String>)new SdkInternalList(supportedFeatureNames.length));
        }
        for (String ele : supportedFeatureNames) {
            this.supportedFeatureNames.add((Object)ele);
        }
        return this;
    }

    public DBEngineVersion withSupportedFeatureNames(Collection<String> supportedFeatureNames) {
        this.setSupportedFeatureNames(supportedFeatureNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getDBParameterGroupFamily() != null) {
            sb.append("DBParameterGroupFamily: ").append(this.getDBParameterGroupFamily()).append(",");
        }
        if (this.getDBEngineDescription() != null) {
            sb.append("DBEngineDescription: ").append(this.getDBEngineDescription()).append(",");
        }
        if (this.getDBEngineVersionDescription() != null) {
            sb.append("DBEngineVersionDescription: ").append(this.getDBEngineVersionDescription()).append(",");
        }
        if (this.getDefaultCharacterSet() != null) {
            sb.append("DefaultCharacterSet: ").append(this.getDefaultCharacterSet()).append(",");
        }
        if (this.getSupportedCharacterSets() != null) {
            sb.append("SupportedCharacterSets: ").append(this.getSupportedCharacterSets()).append(",");
        }
        if (this.getValidUpgradeTarget() != null) {
            sb.append("ValidUpgradeTarget: ").append(this.getValidUpgradeTarget()).append(",");
        }
        if (this.getSupportedTimezones() != null) {
            sb.append("SupportedTimezones: ").append(this.getSupportedTimezones()).append(",");
        }
        if (this.getExportableLogTypes() != null) {
            sb.append("ExportableLogTypes: ").append(this.getExportableLogTypes()).append(",");
        }
        if (this.getSupportsLogExportsToCloudwatchLogs() != null) {
            sb.append("SupportsLogExportsToCloudwatchLogs: ").append(this.getSupportsLogExportsToCloudwatchLogs()).append(",");
        }
        if (this.getSupportsReadReplica() != null) {
            sb.append("SupportsReadReplica: ").append(this.getSupportsReadReplica()).append(",");
        }
        if (this.getSupportedEngineModes() != null) {
            sb.append("SupportedEngineModes: ").append(this.getSupportedEngineModes()).append(",");
        }
        if (this.getSupportedFeatureNames() != null) {
            sb.append("SupportedFeatureNames: ").append(this.getSupportedFeatureNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion)obj;
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getDBParameterGroupFamily() == null ^ this.getDBParameterGroupFamily() == null) {
            return false;
        }
        if (other.getDBParameterGroupFamily() != null && !other.getDBParameterGroupFamily().equals(this.getDBParameterGroupFamily())) {
            return false;
        }
        if (other.getDBEngineDescription() == null ^ this.getDBEngineDescription() == null) {
            return false;
        }
        if (other.getDBEngineDescription() != null && !other.getDBEngineDescription().equals(this.getDBEngineDescription())) {
            return false;
        }
        if (other.getDBEngineVersionDescription() == null ^ this.getDBEngineVersionDescription() == null) {
            return false;
        }
        if (other.getDBEngineVersionDescription() != null && !other.getDBEngineVersionDescription().equals(this.getDBEngineVersionDescription())) {
            return false;
        }
        if (other.getDefaultCharacterSet() == null ^ this.getDefaultCharacterSet() == null) {
            return false;
        }
        if (other.getDefaultCharacterSet() != null && !other.getDefaultCharacterSet().equals(this.getDefaultCharacterSet())) {
            return false;
        }
        if (other.getSupportedCharacterSets() == null ^ this.getSupportedCharacterSets() == null) {
            return false;
        }
        if (other.getSupportedCharacterSets() != null && !other.getSupportedCharacterSets().equals(this.getSupportedCharacterSets())) {
            return false;
        }
        if (other.getValidUpgradeTarget() == null ^ this.getValidUpgradeTarget() == null) {
            return false;
        }
        if (other.getValidUpgradeTarget() != null && !other.getValidUpgradeTarget().equals(this.getValidUpgradeTarget())) {
            return false;
        }
        if (other.getSupportedTimezones() == null ^ this.getSupportedTimezones() == null) {
            return false;
        }
        if (other.getSupportedTimezones() != null && !other.getSupportedTimezones().equals(this.getSupportedTimezones())) {
            return false;
        }
        if (other.getExportableLogTypes() == null ^ this.getExportableLogTypes() == null) {
            return false;
        }
        if (other.getExportableLogTypes() != null && !other.getExportableLogTypes().equals(this.getExportableLogTypes())) {
            return false;
        }
        if (other.getSupportsLogExportsToCloudwatchLogs() == null ^ this.getSupportsLogExportsToCloudwatchLogs() == null) {
            return false;
        }
        if (other.getSupportsLogExportsToCloudwatchLogs() != null && !other.getSupportsLogExportsToCloudwatchLogs().equals(this.getSupportsLogExportsToCloudwatchLogs())) {
            return false;
        }
        if (other.getSupportsReadReplica() == null ^ this.getSupportsReadReplica() == null) {
            return false;
        }
        if (other.getSupportsReadReplica() != null && !other.getSupportsReadReplica().equals(this.getSupportsReadReplica())) {
            return false;
        }
        if (other.getSupportedEngineModes() == null ^ this.getSupportedEngineModes() == null) {
            return false;
        }
        if (other.getSupportedEngineModes() != null && !other.getSupportedEngineModes().equals(this.getSupportedEngineModes())) {
            return false;
        }
        if (other.getSupportedFeatureNames() == null ^ this.getSupportedFeatureNames() == null) {
            return false;
        }
        return other.getSupportedFeatureNames() == null || other.getSupportedFeatureNames().equals(this.getSupportedFeatureNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDBParameterGroupFamily() == null ? 0 : this.getDBParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.getDBEngineDescription() == null ? 0 : this.getDBEngineDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDBEngineVersionDescription() == null ? 0 : this.getDBEngineVersionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCharacterSet() == null ? 0 : this.getDefaultCharacterSet().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedCharacterSets() == null ? 0 : this.getSupportedCharacterSets().hashCode());
        hashCode = 31 * hashCode + (this.getValidUpgradeTarget() == null ? 0 : this.getValidUpgradeTarget().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedTimezones() == null ? 0 : this.getSupportedTimezones().hashCode());
        hashCode = 31 * hashCode + (this.getExportableLogTypes() == null ? 0 : this.getExportableLogTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsLogExportsToCloudwatchLogs() == null ? 0 : this.getSupportsLogExportsToCloudwatchLogs().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsReadReplica() == null ? 0 : this.getSupportsReadReplica().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedEngineModes() == null ? 0 : this.getSupportedEngineModes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedFeatureNames() == null ? 0 : this.getSupportedFeatureNames().hashCode());
        return hashCode;
    }

    public DBEngineVersion clone() {
        try {
            return (DBEngineVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

