/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CloudwatchLogsExportConfiguration;
import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import com.amazonaws.services.rds.model.ProcessorFeature;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBInstanceRequestMarshaller
implements Marshaller<Request<ModifyDBInstanceRequest>, ModifyDBInstanceRequest> {
    public Request<ModifyDBInstanceRequest> marshall(ModifyDBInstanceRequest modifyDBInstanceRequest) {
        CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
        if (modifyDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBInstanceRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBInstanceRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.getDBInstanceIdentifier()));
        }
        if (modifyDBInstanceRequest.getAllocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.getAllocatedStorage()));
        }
        if (modifyDBInstanceRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)modifyDBInstanceRequest.getDBInstanceClass()));
        }
        if (modifyDBInstanceRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)modifyDBInstanceRequest.getDBSubnetGroupName()));
        }
        if (!modifyDBInstanceRequest.getDBSecurityGroups().isEmpty() || !((SdkInternalList)modifyDBInstanceRequest.getDBSecurityGroups()).isAutoConstruct()) {
            SdkInternalList dBSecurityGroupsList = (SdkInternalList)modifyDBInstanceRequest.getDBSecurityGroups();
            int dBSecurityGroupsListIndex = 1;
            for (String dBSecurityGroupsListValue : dBSecurityGroupsList) {
                if (dBSecurityGroupsListValue != null) {
                    request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringUtils.fromString((String)dBSecurityGroupsListValue));
                }
                ++dBSecurityGroupsListIndex;
            }
        }
        if (!modifyDBInstanceRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)modifyDBInstanceRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)modifyDBInstanceRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (Object vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (modifyDBInstanceRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getApplyImmediately()));
        }
        if (modifyDBInstanceRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)modifyDBInstanceRequest.getMasterUserPassword()));
        }
        if (modifyDBInstanceRequest.getDBParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)modifyDBInstanceRequest.getDBParameterGroupName()));
        }
        if (modifyDBInstanceRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.getBackupRetentionPeriod()));
        }
        if (modifyDBInstanceRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)modifyDBInstanceRequest.getPreferredBackupWindow()));
        }
        if (modifyDBInstanceRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyDBInstanceRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyDBInstanceRequest.getMultiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getMultiAZ()));
        }
        if (modifyDBInstanceRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyDBInstanceRequest.getEngineVersion()));
        }
        if (modifyDBInstanceRequest.getAllowMajorVersionUpgrade() != null) {
            request.addParameter("AllowMajorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getAllowMajorVersionUpgrade()));
        }
        if (modifyDBInstanceRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getAutoMinorVersionUpgrade()));
        }
        if (modifyDBInstanceRequest.getLicenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)modifyDBInstanceRequest.getLicenseModel()));
        }
        if (modifyDBInstanceRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.getIops()));
        }
        if (modifyDBInstanceRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)modifyDBInstanceRequest.getOptionGroupName()));
        }
        if (modifyDBInstanceRequest.getNewDBInstanceIdentifier() != null) {
            request.addParameter("NewDBInstanceIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.getNewDBInstanceIdentifier()));
        }
        if (modifyDBInstanceRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)modifyDBInstanceRequest.getStorageType()));
        }
        if (modifyDBInstanceRequest.getTdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringUtils.fromString((String)modifyDBInstanceRequest.getTdeCredentialArn()));
        }
        if (modifyDBInstanceRequest.getTdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringUtils.fromString((String)modifyDBInstanceRequest.getTdeCredentialPassword()));
        }
        if (modifyDBInstanceRequest.getCACertificateIdentifier() != null) {
            request.addParameter("CACertificateIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.getCACertificateIdentifier()));
        }
        if (modifyDBInstanceRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)modifyDBInstanceRequest.getDomain()));
        }
        if (modifyDBInstanceRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getCopyTagsToSnapshot()));
        }
        if (modifyDBInstanceRequest.getMonitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.getMonitoringInterval()));
        }
        if (modifyDBInstanceRequest.getDBPortNumber() != null) {
            request.addParameter("DBPortNumber", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.getDBPortNumber()));
        }
        if (modifyDBInstanceRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getPubliclyAccessible()));
        }
        if (modifyDBInstanceRequest.getMonitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)modifyDBInstanceRequest.getMonitoringRoleArn()));
        }
        if (modifyDBInstanceRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)modifyDBInstanceRequest.getDomainIAMRoleName()));
        }
        if (modifyDBInstanceRequest.getPromotionTier() != null) {
            request.addParameter("PromotionTier", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.getPromotionTier()));
        }
        if (modifyDBInstanceRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (modifyDBInstanceRequest.getEnablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getEnablePerformanceInsights()));
        }
        if (modifyDBInstanceRequest.getPerformanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString((String)modifyDBInstanceRequest.getPerformanceInsightsKMSKeyId()));
        }
        if (modifyDBInstanceRequest.getPerformanceInsightsRetentionPeriod() != null) {
            request.addParameter("PerformanceInsightsRetentionPeriod", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.getPerformanceInsightsRetentionPeriod()));
        }
        if ((cloudwatchLogsExportConfiguration = modifyDBInstanceRequest.getCloudwatchLogsExportConfiguration()) != null) {
            if (!cloudwatchLogsExportConfiguration.getEnableLogTypes().isEmpty() || !((SdkInternalList)cloudwatchLogsExportConfiguration.getEnableLogTypes()).isAutoConstruct()) {
                SdkInternalList enableLogTypesList = (SdkInternalList)cloudwatchLogsExportConfiguration.getEnableLogTypes();
                int enableLogTypesListIndex = 1;
                for (String enableLogTypesListValue : enableLogTypesList) {
                    if (enableLogTypesListValue != null) {
                        request.addParameter("CloudwatchLogsExportConfiguration.EnableLogTypes.member." + enableLogTypesListIndex, StringUtils.fromString((String)enableLogTypesListValue));
                    }
                    ++enableLogTypesListIndex;
                }
            }
            if (!cloudwatchLogsExportConfiguration.getDisableLogTypes().isEmpty() || !((SdkInternalList)cloudwatchLogsExportConfiguration.getDisableLogTypes()).isAutoConstruct()) {
                SdkInternalList disableLogTypesList = (SdkInternalList)cloudwatchLogsExportConfiguration.getDisableLogTypes();
                int disableLogTypesListIndex = 1;
                for (String disableLogTypesListValue : disableLogTypesList) {
                    if (disableLogTypesListValue != null) {
                        request.addParameter("CloudwatchLogsExportConfiguration.DisableLogTypes.member." + disableLogTypesListIndex, StringUtils.fromString((String)disableLogTypesListValue));
                    }
                    ++disableLogTypesListIndex;
                }
            }
        }
        if (!modifyDBInstanceRequest.getProcessorFeatures().isEmpty() || !((SdkInternalList)modifyDBInstanceRequest.getProcessorFeatures()).isAutoConstruct()) {
            SdkInternalList processorFeaturesList = (SdkInternalList)modifyDBInstanceRequest.getProcessorFeatures();
            int processorFeaturesListIndex = 1;
            for (ProcessorFeature processorFeaturesListValue : processorFeaturesList) {
                if (processorFeaturesListValue.getName() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Name", StringUtils.fromString((String)processorFeaturesListValue.getName()));
                }
                if (processorFeaturesListValue.getValue() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Value", StringUtils.fromString((String)processorFeaturesListValue.getValue()));
                }
                ++processorFeaturesListIndex;
            }
        }
        if (modifyDBInstanceRequest.getUseDefaultProcessorFeatures() != null) {
            request.addParameter("UseDefaultProcessorFeatures", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getUseDefaultProcessorFeatures()));
        }
        if (modifyDBInstanceRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getDeletionProtection()));
        }
        return request;
    }
}

