/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.rds.model.StartActivityStreamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class StartActivityStreamRequestMarshaller
implements Marshaller<Request<StartActivityStreamRequest>, StartActivityStreamRequest> {
    public Request<StartActivityStreamRequest> marshall(StartActivityStreamRequest startActivityStreamRequest) {
        if (startActivityStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startActivityStreamRequest, "AmazonRDS");
        request.addParameter("Action", "StartActivityStream");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (startActivityStreamRequest.getResourceArn() != null) {
            request.addParameter("ResourceArn", StringUtils.fromString((String)startActivityStreamRequest.getResourceArn()));
        }
        if (startActivityStreamRequest.getMode() != null) {
            request.addParameter("Mode", StringUtils.fromString((String)startActivityStreamRequest.getMode()));
        }
        if (startActivityStreamRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)startActivityStreamRequest.getKmsKeyId()));
        }
        if (startActivityStreamRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)startActivityStreamRequest.getApplyImmediately()));
        }
        return request;
    }
}

