/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.CharacterSet;
import com.amazonaws.services.rds.model.DBEngineVersion;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.services.rds.model.Timezone;
import com.amazonaws.services.rds.model.UpgradeTarget;
import com.amazonaws.services.rds.model.transform.CharacterSetStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.CustomDBEngineVersionAMIStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.TagStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.TimezoneStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.UpgradeTargetStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DBEngineVersionStaxUnmarshaller
implements Unmarshaller<DBEngineVersion, StaxUnmarshallerContext> {
    private static DBEngineVersionStaxUnmarshaller instance;

    public DBEngineVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBEngineVersion dBEngineVersion = new DBEngineVersion();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dBEngineVersion;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    dBEngineVersion.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    dBEngineVersion.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                    dBEngineVersion.setDBParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineDescription", targetDepth)) {
                    dBEngineVersion.setDBEngineDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineVersionDescription", targetDepth)) {
                    dBEngineVersion.setDBEngineVersionDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultCharacterSet", targetDepth)) {
                    dBEngineVersion.setDefaultCharacterSet(CharacterSetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Image", targetDepth)) {
                    dBEngineVersion.setImage(CustomDBEngineVersionAMIStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineMediaType", targetDepth)) {
                    dBEngineVersion.setDBEngineMediaType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedCharacterSets", targetDepth)) {
                    dBEngineVersion.withSupportedCharacterSets(new ArrayList<CharacterSet>());
                    continue;
                }
                if (context.testExpression("SupportedCharacterSets/CharacterSet", targetDepth)) {
                    dBEngineVersion.withSupportedCharacterSets(CharacterSetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedNcharCharacterSets", targetDepth)) {
                    dBEngineVersion.withSupportedNcharCharacterSets(new ArrayList<CharacterSet>());
                    continue;
                }
                if (context.testExpression("SupportedNcharCharacterSets/CharacterSet", targetDepth)) {
                    dBEngineVersion.withSupportedNcharCharacterSets(CharacterSetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ValidUpgradeTarget", targetDepth)) {
                    dBEngineVersion.withValidUpgradeTarget(new ArrayList<UpgradeTarget>());
                    continue;
                }
                if (context.testExpression("ValidUpgradeTarget/UpgradeTarget", targetDepth)) {
                    dBEngineVersion.withValidUpgradeTarget(UpgradeTargetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedTimezones", targetDepth)) {
                    dBEngineVersion.withSupportedTimezones(new ArrayList<Timezone>());
                    continue;
                }
                if (context.testExpression("SupportedTimezones/Timezone", targetDepth)) {
                    dBEngineVersion.withSupportedTimezones(TimezoneStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExportableLogTypes", targetDepth)) {
                    dBEngineVersion.withExportableLogTypes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ExportableLogTypes/member", targetDepth)) {
                    dBEngineVersion.withExportableLogTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportsLogExportsToCloudwatchLogs", targetDepth)) {
                    dBEngineVersion.setSupportsLogExportsToCloudwatchLogs(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportsReadReplica", targetDepth)) {
                    dBEngineVersion.setSupportsReadReplica(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedEngineModes", targetDepth)) {
                    dBEngineVersion.withSupportedEngineModes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SupportedEngineModes/member", targetDepth)) {
                    dBEngineVersion.withSupportedEngineModes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedFeatureNames", targetDepth)) {
                    dBEngineVersion.withSupportedFeatureNames(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SupportedFeatureNames/member", targetDepth)) {
                    dBEngineVersion.withSupportedFeatureNames(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    dBEngineVersion.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportsParallelQuery", targetDepth)) {
                    dBEngineVersion.setSupportsParallelQuery(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportsGlobalDatabases", targetDepth)) {
                    dBEngineVersion.setSupportsGlobalDatabases(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MajorEngineVersion", targetDepth)) {
                    dBEngineVersion.setMajorEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DatabaseInstallationFilesS3BucketName", targetDepth)) {
                    dBEngineVersion.setDatabaseInstallationFilesS3BucketName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DatabaseInstallationFilesS3Prefix", targetDepth)) {
                    dBEngineVersion.setDatabaseInstallationFilesS3Prefix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineVersionArn", targetDepth)) {
                    dBEngineVersion.setDBEngineVersionArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KMSKeyId", targetDepth)) {
                    dBEngineVersion.setKMSKeyId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    dBEngineVersion.setCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("TagList", targetDepth)) {
                    dBEngineVersion.withTagList(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("TagList/Tag", targetDepth)) {
                    dBEngineVersion.withTagList(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportsBabelfish", targetDepth)) {
                    dBEngineVersion.setSupportsBabelfish(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomDBEngineVersionManifest", targetDepth)) {
                    dBEngineVersion.setCustomDBEngineVersionManifest(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportsCertificateRotationWithoutRestart", targetDepth)) {
                    dBEngineVersion.setSupportsCertificateRotationWithoutRestart(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedCACertificateIdentifiers", targetDepth)) {
                    dBEngineVersion.withSupportedCACertificateIdentifiers(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("SupportedCACertificateIdentifiers/member", targetDepth)) continue;
                dBEngineVersion.withSupportedCACertificateIdentifiers(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dBEngineVersion;
    }

    public static DBEngineVersionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DBEngineVersionStaxUnmarshaller();
        }
        return instance;
    }
}

