/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rds.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p/>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FailoverDBClusterRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the DB cluster to force a failover for. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DB cluster.
     * </p>
     * </li>
     * </ul>
     */
    private String dBClusterIdentifier;
    /**
     * <p>
     * The name of the DB instance to promote to the primary DB instance.
     * </p>
     * <p>
     * Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB cluster, for
     * example <code>mydbcluster-replica1</code>.
     * </p>
     * <p>
     * This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
     * </p>
     */
    private String targetDBInstanceIdentifier;

    /**
     * <p>
     * The identifier of the DB cluster to force a failover for. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @param dBClusterIdentifier
     *        The identifier of the DB cluster to force a failover for. This parameter isn't case-sensitive.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Must match the identifier of an existing DB cluster.
     *        </p>
     *        </li>
     */

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the DB cluster to force a failover for. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the DB cluster to force a failover for. This parameter isn't case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DB cluster.
     *         </p>
     *         </li>
     */

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the DB cluster to force a failover for. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @param dBClusterIdentifier
     *        The identifier of the DB cluster to force a failover for. This parameter isn't case-sensitive.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Must match the identifier of an existing DB cluster.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FailoverDBClusterRequest withDBClusterIdentifier(String dBClusterIdentifier) {
        setDBClusterIdentifier(dBClusterIdentifier);
        return this;
    }

    /**
     * <p>
     * The name of the DB instance to promote to the primary DB instance.
     * </p>
     * <p>
     * Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB cluster, for
     * example <code>mydbcluster-replica1</code>.
     * </p>
     * <p>
     * This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
     * </p>
     * 
     * @param targetDBInstanceIdentifier
     *        The name of the DB instance to promote to the primary DB instance.</p>
     *        <p>
     *        Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB cluster,
     *        for example <code>mydbcluster-replica1</code>.
     *        </p>
     *        <p>
     *        This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
     */

    public void setTargetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
        this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
    }

    /**
     * <p>
     * The name of the DB instance to promote to the primary DB instance.
     * </p>
     * <p>
     * Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB cluster, for
     * example <code>mydbcluster-replica1</code>.
     * </p>
     * <p>
     * This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
     * </p>
     * 
     * @return The name of the DB instance to promote to the primary DB instance.</p>
     *         <p>
     *         Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB
     *         cluster, for example <code>mydbcluster-replica1</code>.
     *         </p>
     *         <p>
     *         This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
     */

    public String getTargetDBInstanceIdentifier() {
        return this.targetDBInstanceIdentifier;
    }

    /**
     * <p>
     * The name of the DB instance to promote to the primary DB instance.
     * </p>
     * <p>
     * Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB cluster, for
     * example <code>mydbcluster-replica1</code>.
     * </p>
     * <p>
     * This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
     * </p>
     * 
     * @param targetDBInstanceIdentifier
     *        The name of the DB instance to promote to the primary DB instance.</p>
     *        <p>
     *        Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB cluster,
     *        for example <code>mydbcluster-replica1</code>.
     *        </p>
     *        <p>
     *        This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FailoverDBClusterRequest withTargetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
        setTargetDBInstanceIdentifier(targetDBInstanceIdentifier);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDBClusterIdentifier() != null)
            sb.append("DBClusterIdentifier: ").append(getDBClusterIdentifier()).append(",");
        if (getTargetDBInstanceIdentifier() != null)
            sb.append("TargetDBInstanceIdentifier: ").append(getTargetDBInstanceIdentifier());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FailoverDBClusterRequest == false)
            return false;
        FailoverDBClusterRequest other = (FailoverDBClusterRequest) obj;
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null)
            return false;
        if (other.getDBClusterIdentifier() != null && other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier()) == false)
            return false;
        if (other.getTargetDBInstanceIdentifier() == null ^ this.getTargetDBInstanceIdentifier() == null)
            return false;
        if (other.getTargetDBInstanceIdentifier() != null && other.getTargetDBInstanceIdentifier().equals(this.getTargetDBInstanceIdentifier()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDBClusterIdentifier() == null) ? 0 : getDBClusterIdentifier().hashCode());
        hashCode = prime * hashCode + ((getTargetDBInstanceIdentifier() == null) ? 0 : getTargetDBInstanceIdentifier().hashCode());
        return hashCode;
    }

    @Override
    public FailoverDBClusterRequest clone() {
        return (FailoverDBClusterRequest) super.clone();
    }

}
