/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.rdsdata.AWSRDSDataAsync;
import com.amazonaws.services.rdsdata.AWSRDSDataAsyncClientBuilder;
import com.amazonaws.services.rdsdata.AWSRDSDataClient;
import com.amazonaws.services.rdsdata.model.ExecuteSqlRequest;
import com.amazonaws.services.rdsdata.model.ExecuteSqlResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSRDSDataAsyncClient
extends AWSRDSDataClient
implements AWSRDSDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSRDSDataAsyncClientBuilder asyncBuilder() {
        return AWSRDSDataAsyncClientBuilder.standard();
    }

    AWSRDSDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ExecuteSqlResult> executeSqlAsync(ExecuteSqlRequest request) {
        return this.executeSqlAsync(request, null);
    }

    @Override
    public Future<ExecuteSqlResult> executeSqlAsync(ExecuteSqlRequest request, final AsyncHandler<ExecuteSqlRequest, ExecuteSqlResult> asyncHandler) {
        final ExecuteSqlRequest finalRequest = (ExecuteSqlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExecuteSqlResult>(){

            @Override
            public ExecuteSqlResult call() throws Exception {
                ExecuteSqlResult result = null;
                try {
                    result = AWSRDSDataAsyncClient.this.executeExecuteSql(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

