/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.rdsdata.AWSRDSDataAsync;
import com.amazonaws.services.rdsdata.AWSRDSDataAsyncClientBuilder;
import com.amazonaws.services.rdsdata.AWSRDSDataClient;
import com.amazonaws.services.rdsdata.model.BatchExecuteStatementRequest;
import com.amazonaws.services.rdsdata.model.BatchExecuteStatementResult;
import com.amazonaws.services.rdsdata.model.BeginTransactionRequest;
import com.amazonaws.services.rdsdata.model.BeginTransactionResult;
import com.amazonaws.services.rdsdata.model.CommitTransactionRequest;
import com.amazonaws.services.rdsdata.model.CommitTransactionResult;
import com.amazonaws.services.rdsdata.model.ExecuteSqlRequest;
import com.amazonaws.services.rdsdata.model.ExecuteSqlResult;
import com.amazonaws.services.rdsdata.model.ExecuteStatementRequest;
import com.amazonaws.services.rdsdata.model.ExecuteStatementResult;
import com.amazonaws.services.rdsdata.model.RollbackTransactionRequest;
import com.amazonaws.services.rdsdata.model.RollbackTransactionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSRDSDataAsyncClient
extends AWSRDSDataClient
implements AWSRDSDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSRDSDataAsyncClientBuilder asyncBuilder() {
        return AWSRDSDataAsyncClientBuilder.standard();
    }

    AWSRDSDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSRDSDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchExecuteStatementResult> batchExecuteStatementAsync(BatchExecuteStatementRequest request) {
        return this.batchExecuteStatementAsync(request, null);
    }

    @Override
    public Future<BatchExecuteStatementResult> batchExecuteStatementAsync(BatchExecuteStatementRequest request, final AsyncHandler<BatchExecuteStatementRequest, BatchExecuteStatementResult> asyncHandler) {
        final BatchExecuteStatementRequest finalRequest = (BatchExecuteStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchExecuteStatementResult>(){

            @Override
            public BatchExecuteStatementResult call() throws Exception {
                BatchExecuteStatementResult result = null;
                try {
                    result = AWSRDSDataAsyncClient.this.executeBatchExecuteStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BeginTransactionResult> beginTransactionAsync(BeginTransactionRequest request) {
        return this.beginTransactionAsync(request, null);
    }

    @Override
    public Future<BeginTransactionResult> beginTransactionAsync(BeginTransactionRequest request, final AsyncHandler<BeginTransactionRequest, BeginTransactionResult> asyncHandler) {
        final BeginTransactionRequest finalRequest = (BeginTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BeginTransactionResult>(){

            @Override
            public BeginTransactionResult call() throws Exception {
                BeginTransactionResult result = null;
                try {
                    result = AWSRDSDataAsyncClient.this.executeBeginTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CommitTransactionResult> commitTransactionAsync(CommitTransactionRequest request) {
        return this.commitTransactionAsync(request, null);
    }

    @Override
    public Future<CommitTransactionResult> commitTransactionAsync(CommitTransactionRequest request, final AsyncHandler<CommitTransactionRequest, CommitTransactionResult> asyncHandler) {
        final CommitTransactionRequest finalRequest = (CommitTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CommitTransactionResult>(){

            @Override
            public CommitTransactionResult call() throws Exception {
                CommitTransactionResult result = null;
                try {
                    result = AWSRDSDataAsyncClient.this.executeCommitTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<ExecuteSqlResult> executeSqlAsync(ExecuteSqlRequest request) {
        return this.executeSqlAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<ExecuteSqlResult> executeSqlAsync(ExecuteSqlRequest request, final AsyncHandler<ExecuteSqlRequest, ExecuteSqlResult> asyncHandler) {
        final ExecuteSqlRequest finalRequest = (ExecuteSqlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExecuteSqlResult>(){

            @Override
            public ExecuteSqlResult call() throws Exception {
                ExecuteSqlResult result = null;
                try {
                    result = AWSRDSDataAsyncClient.this.executeExecuteSql(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExecuteStatementResult> executeStatementAsync(ExecuteStatementRequest request) {
        return this.executeStatementAsync(request, null);
    }

    @Override
    public Future<ExecuteStatementResult> executeStatementAsync(ExecuteStatementRequest request, final AsyncHandler<ExecuteStatementRequest, ExecuteStatementResult> asyncHandler) {
        final ExecuteStatementRequest finalRequest = (ExecuteStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExecuteStatementResult>(){

            @Override
            public ExecuteStatementResult call() throws Exception {
                ExecuteStatementResult result = null;
                try {
                    result = AWSRDSDataAsyncClient.this.executeExecuteStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RollbackTransactionResult> rollbackTransactionAsync(RollbackTransactionRequest request) {
        return this.rollbackTransactionAsync(request, null);
    }

    @Override
    public Future<RollbackTransactionResult> rollbackTransactionAsync(RollbackTransactionRequest request, final AsyncHandler<RollbackTransactionRequest, RollbackTransactionResult> asyncHandler) {
        final RollbackTransactionRequest finalRequest = (RollbackTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RollbackTransactionResult>(){

            @Override
            public RollbackTransactionResult call() throws Exception {
                RollbackTransactionResult result = null;
                try {
                    result = AWSRDSDataAsyncClient.this.executeRollbackTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

