/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rdsdata.model.Value;
import com.amazonaws.services.rdsdata.model.transform.RecordMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Record
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Value> values;

    public List<Value> getValues() {
        return this.values;
    }

    public void setValues(Collection<Value> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<Value>(values);
    }

    public Record withValues(Value ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<Value>(values.length));
        }
        for (Value ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public Record withValues(Collection<Value> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public Record clone() {
        try {
            return (Record)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

