/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.recyclebin.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.recyclebin.model.LockConfiguration;
import com.amazonaws.services.recyclebin.model.LockState;
import com.amazonaws.services.recyclebin.model.ResourceTag;
import com.amazonaws.services.recyclebin.model.ResourceType;
import com.amazonaws.services.recyclebin.model.RetentionPeriod;
import com.amazonaws.services.recyclebin.model.RuleStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UnlockRuleResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String identifier;
    private String description;
    private String resourceType;
    private RetentionPeriod retentionPeriod;
    private List<ResourceTag> resourceTags;
    private String status;
    private LockConfiguration lockConfiguration;
    private String lockState;
    private Date lockEndTime;

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public UnlockRuleResult withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UnlockRuleResult withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public UnlockRuleResult withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public UnlockRuleResult withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public RetentionPeriod getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public UnlockRuleResult withRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    public List<ResourceTag> getResourceTags() {
        return this.resourceTags;
    }

    public void setResourceTags(Collection<ResourceTag> resourceTags) {
        if (resourceTags == null) {
            this.resourceTags = null;
            return;
        }
        this.resourceTags = new ArrayList<ResourceTag>(resourceTags);
    }

    public UnlockRuleResult withResourceTags(ResourceTag ... resourceTags) {
        if (this.resourceTags == null) {
            this.setResourceTags(new ArrayList<ResourceTag>(resourceTags.length));
        }
        for (ResourceTag ele : resourceTags) {
            this.resourceTags.add(ele);
        }
        return this;
    }

    public UnlockRuleResult withResourceTags(Collection<ResourceTag> resourceTags) {
        this.setResourceTags(resourceTags);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public UnlockRuleResult withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public UnlockRuleResult withStatus(RuleStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setLockConfiguration(LockConfiguration lockConfiguration) {
        this.lockConfiguration = lockConfiguration;
    }

    public LockConfiguration getLockConfiguration() {
        return this.lockConfiguration;
    }

    public UnlockRuleResult withLockConfiguration(LockConfiguration lockConfiguration) {
        this.setLockConfiguration(lockConfiguration);
        return this;
    }

    public void setLockState(String lockState) {
        this.lockState = lockState;
    }

    public String getLockState() {
        return this.lockState;
    }

    public UnlockRuleResult withLockState(String lockState) {
        this.setLockState(lockState);
        return this;
    }

    public UnlockRuleResult withLockState(LockState lockState) {
        this.lockState = lockState.toString();
        return this;
    }

    public void setLockEndTime(Date lockEndTime) {
        this.lockEndTime = lockEndTime;
    }

    public Date getLockEndTime() {
        return this.lockEndTime;
    }

    public UnlockRuleResult withLockEndTime(Date lockEndTime) {
        this.setLockEndTime(lockEndTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentifier() != null) {
            sb.append("Identifier: ").append(this.getIdentifier()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getRetentionPeriod() != null) {
            sb.append("RetentionPeriod: ").append(this.getRetentionPeriod()).append(",");
        }
        if (this.getResourceTags() != null) {
            sb.append("ResourceTags: ").append(this.getResourceTags()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getLockConfiguration() != null) {
            sb.append("LockConfiguration: ").append(this.getLockConfiguration()).append(",");
        }
        if (this.getLockState() != null) {
            sb.append("LockState: ").append(this.getLockState()).append(",");
        }
        if (this.getLockEndTime() != null) {
            sb.append("LockEndTime: ").append(this.getLockEndTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlockRuleResult)) {
            return false;
        }
        UnlockRuleResult other = (UnlockRuleResult)obj;
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getRetentionPeriod() == null ^ this.getRetentionPeriod() == null) {
            return false;
        }
        if (other.getRetentionPeriod() != null && !other.getRetentionPeriod().equals(this.getRetentionPeriod())) {
            return false;
        }
        if (other.getResourceTags() == null ^ this.getResourceTags() == null) {
            return false;
        }
        if (other.getResourceTags() != null && !other.getResourceTags().equals(this.getResourceTags())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLockConfiguration() == null ^ this.getLockConfiguration() == null) {
            return false;
        }
        if (other.getLockConfiguration() != null && !other.getLockConfiguration().equals(this.getLockConfiguration())) {
            return false;
        }
        if (other.getLockState() == null ^ this.getLockState() == null) {
            return false;
        }
        if (other.getLockState() != null && !other.getLockState().equals(this.getLockState())) {
            return false;
        }
        if (other.getLockEndTime() == null ^ this.getLockEndTime() == null) {
            return false;
        }
        return other.getLockEndTime() == null || other.getLockEndTime().equals(this.getLockEndTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionPeriod() == null ? 0 : this.getRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTags() == null ? 0 : this.getResourceTags().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLockConfiguration() == null ? 0 : this.getLockConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLockState() == null ? 0 : this.getLockState().hashCode());
        hashCode = 31 * hashCode + (this.getLockEndTime() == null ? 0 : this.getLockEndTime().hashCode());
        return hashCode;
    }

    public UnlockRuleResult clone() {
        try {
            return (UnlockRuleResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

