/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.RevisionTarget;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ClusterDbRevision
implements Serializable,
Cloneable {
    private String clusterIdentifier;
    private String currentDatabaseRevision;
    private Date databaseRevisionReleaseDate;
    private SdkInternalList<RevisionTarget> revisionTargets;

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public ClusterDbRevision withClusterIdentifier(String clusterIdentifier) {
        this.setClusterIdentifier(clusterIdentifier);
        return this;
    }

    public void setCurrentDatabaseRevision(String currentDatabaseRevision) {
        this.currentDatabaseRevision = currentDatabaseRevision;
    }

    public String getCurrentDatabaseRevision() {
        return this.currentDatabaseRevision;
    }

    public ClusterDbRevision withCurrentDatabaseRevision(String currentDatabaseRevision) {
        this.setCurrentDatabaseRevision(currentDatabaseRevision);
        return this;
    }

    public void setDatabaseRevisionReleaseDate(Date databaseRevisionReleaseDate) {
        this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
    }

    public Date getDatabaseRevisionReleaseDate() {
        return this.databaseRevisionReleaseDate;
    }

    public ClusterDbRevision withDatabaseRevisionReleaseDate(Date databaseRevisionReleaseDate) {
        this.setDatabaseRevisionReleaseDate(databaseRevisionReleaseDate);
        return this;
    }

    public List<RevisionTarget> getRevisionTargets() {
        if (this.revisionTargets == null) {
            this.revisionTargets = new SdkInternalList();
        }
        return this.revisionTargets;
    }

    public void setRevisionTargets(Collection<RevisionTarget> revisionTargets) {
        if (revisionTargets == null) {
            this.revisionTargets = null;
            return;
        }
        this.revisionTargets = new SdkInternalList(revisionTargets);
    }

    public ClusterDbRevision withRevisionTargets(RevisionTarget ... revisionTargets) {
        if (this.revisionTargets == null) {
            this.setRevisionTargets((Collection<RevisionTarget>)new SdkInternalList(revisionTargets.length));
        }
        for (RevisionTarget ele : revisionTargets) {
            this.revisionTargets.add((Object)ele);
        }
        return this;
    }

    public ClusterDbRevision withRevisionTargets(Collection<RevisionTarget> revisionTargets) {
        this.setRevisionTargets(revisionTargets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.getClusterIdentifier()).append(",");
        }
        if (this.getCurrentDatabaseRevision() != null) {
            sb.append("CurrentDatabaseRevision: ").append(this.getCurrentDatabaseRevision()).append(",");
        }
        if (this.getDatabaseRevisionReleaseDate() != null) {
            sb.append("DatabaseRevisionReleaseDate: ").append(this.getDatabaseRevisionReleaseDate()).append(",");
        }
        if (this.getRevisionTargets() != null) {
            sb.append("RevisionTargets: ").append(this.getRevisionTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterDbRevision)) {
            return false;
        }
        ClusterDbRevision other = (ClusterDbRevision)obj;
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getCurrentDatabaseRevision() == null ^ this.getCurrentDatabaseRevision() == null) {
            return false;
        }
        if (other.getCurrentDatabaseRevision() != null && !other.getCurrentDatabaseRevision().equals(this.getCurrentDatabaseRevision())) {
            return false;
        }
        if (other.getDatabaseRevisionReleaseDate() == null ^ this.getDatabaseRevisionReleaseDate() == null) {
            return false;
        }
        if (other.getDatabaseRevisionReleaseDate() != null && !other.getDatabaseRevisionReleaseDate().equals(this.getDatabaseRevisionReleaseDate())) {
            return false;
        }
        if (other.getRevisionTargets() == null ^ this.getRevisionTargets() == null) {
            return false;
        }
        return other.getRevisionTargets() == null || other.getRevisionTargets().equals(this.getRevisionTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentDatabaseRevision() == null ? 0 : this.getCurrentDatabaseRevision().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseRevisionReleaseDate() == null ? 0 : this.getDatabaseRevisionReleaseDate().hashCode());
        hashCode = 31 * hashCode + (this.getRevisionTargets() == null ? 0 : this.getRevisionTargets().hashCode());
        return hashCode;
    }

    public ClusterDbRevision clone() {
        try {
            return (ClusterDbRevision)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

