/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.AddPartnerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AddPartnerRequestMarshaller
implements Marshaller<Request<AddPartnerRequest>, AddPartnerRequest> {
    public Request<AddPartnerRequest> marshall(AddPartnerRequest addPartnerRequest) {
        if (addPartnerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addPartnerRequest, "AmazonRedshift");
        request.addParameter("Action", "AddPartner");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (addPartnerRequest.getAccountId() != null) {
            request.addParameter("AccountId", StringUtils.fromString((String)addPartnerRequest.getAccountId()));
        }
        if (addPartnerRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)addPartnerRequest.getClusterIdentifier()));
        }
        if (addPartnerRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)addPartnerRequest.getDatabaseName()));
        }
        if (addPartnerRequest.getPartnerName() != null) {
            request.addParameter("PartnerName", StringUtils.fromString((String)addPartnerRequest.getPartnerName()));
        }
        return request;
    }
}

