/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.CreateEndpointAccessRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateEndpointAccessRequestMarshaller
implements Marshaller<Request<CreateEndpointAccessRequest>, CreateEndpointAccessRequest> {
    public Request<CreateEndpointAccessRequest> marshall(CreateEndpointAccessRequest createEndpointAccessRequest) {
        if (createEndpointAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createEndpointAccessRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateEndpointAccess");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEndpointAccessRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)createEndpointAccessRequest.getClusterIdentifier()));
        }
        if (createEndpointAccessRequest.getResourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString((String)createEndpointAccessRequest.getResourceOwner()));
        }
        if (createEndpointAccessRequest.getEndpointName() != null) {
            request.addParameter("EndpointName", StringUtils.fromString((String)createEndpointAccessRequest.getEndpointName()));
        }
        if (createEndpointAccessRequest.getSubnetGroupName() != null) {
            request.addParameter("SubnetGroupName", StringUtils.fromString((String)createEndpointAccessRequest.getSubnetGroupName()));
        }
        if (!createEndpointAccessRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)createEndpointAccessRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)createEndpointAccessRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        return request;
    }
}

