/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.Cluster;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeClustersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private SdkInternalList<Cluster> clusters;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeClustersResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<Cluster> getClusters() {
        if (this.clusters == null) {
            this.clusters = new SdkInternalList();
        }
        return this.clusters;
    }

    public void setClusters(Collection<Cluster> clusters) {
        if (clusters == null) {
            this.clusters = null;
            return;
        }
        this.clusters = new SdkInternalList(clusters);
    }

    public DescribeClustersResult withClusters(Cluster ... clusters) {
        if (this.clusters == null) {
            this.setClusters((Collection<Cluster>)new SdkInternalList(clusters.length));
        }
        for (Cluster ele : clusters) {
            this.clusters.add((Object)ele);
        }
        return this;
    }

    public DescribeClustersResult withClusters(Collection<Cluster> clusters) {
        this.setClusters(clusters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getClusters() != null) {
            sb.append("Clusters: ").append(this.getClusters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResult)) {
            return false;
        }
        DescribeClustersResult other = (DescribeClustersResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getClusters() == null ^ this.getClusters() == null) {
            return false;
        }
        return other.getClusters() == null || other.getClusters().equals(this.getClusters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getClusters() == null ? 0 : this.getClusters().hashCode());
        return hashCode;
    }

    public DescribeClustersResult clone() {
        try {
            return (DescribeClustersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

