/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.RevokeEndpointAccessRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RevokeEndpointAccessRequestMarshaller
implements Marshaller<Request<RevokeEndpointAccessRequest>, RevokeEndpointAccessRequest> {
    public Request<RevokeEndpointAccessRequest> marshall(RevokeEndpointAccessRequest revokeEndpointAccessRequest) {
        if (revokeEndpointAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)revokeEndpointAccessRequest, "AmazonRedshift");
        request.addParameter("Action", "RevokeEndpointAccess");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeEndpointAccessRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)revokeEndpointAccessRequest.getClusterIdentifier()));
        }
        if (revokeEndpointAccessRequest.getAccount() != null) {
            request.addParameter("Account", StringUtils.fromString((String)revokeEndpointAccessRequest.getAccount()));
        }
        if (!revokeEndpointAccessRequest.getVpcIds().isEmpty() || !((SdkInternalList)revokeEndpointAccessRequest.getVpcIds()).isAutoConstruct()) {
            SdkInternalList vpcIdsList = (SdkInternalList)revokeEndpointAccessRequest.getVpcIds();
            int vpcIdsListIndex = 1;
            for (String vpcIdsListValue : vpcIdsList) {
                if (vpcIdsListValue != null) {
                    request.addParameter("VpcIds.VpcIdentifier." + vpcIdsListIndex, StringUtils.fromString((String)vpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        if (revokeEndpointAccessRequest.getForce() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)revokeEndpointAccessRequest.getForce()));
        }
        return request;
    }
}

