/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.ScheduledActionFilter;
import com.amazonaws.services.redshift.model.ScheduledActionTypeValues;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DescribeScheduledActionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String scheduledActionName;
    private String targetActionType;
    private Date startTime;
    private Date endTime;
    private Boolean active;
    private SdkInternalList<ScheduledActionFilter> filters;
    private String marker;
    private Integer maxRecords;

    public void setScheduledActionName(String scheduledActionName) {
        this.scheduledActionName = scheduledActionName;
    }

    public String getScheduledActionName() {
        return this.scheduledActionName;
    }

    public DescribeScheduledActionsRequest withScheduledActionName(String scheduledActionName) {
        this.setScheduledActionName(scheduledActionName);
        return this;
    }

    public void setTargetActionType(String targetActionType) {
        this.targetActionType = targetActionType;
    }

    public String getTargetActionType() {
        return this.targetActionType;
    }

    public DescribeScheduledActionsRequest withTargetActionType(String targetActionType) {
        this.setTargetActionType(targetActionType);
        return this;
    }

    public DescribeScheduledActionsRequest withTargetActionType(ScheduledActionTypeValues targetActionType) {
        this.targetActionType = targetActionType.toString();
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public DescribeScheduledActionsRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public DescribeScheduledActionsRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean getActive() {
        return this.active;
    }

    public DescribeScheduledActionsRequest withActive(Boolean active) {
        this.setActive(active);
        return this;
    }

    public Boolean isActive() {
        return this.active;
    }

    public List<ScheduledActionFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<ScheduledActionFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public DescribeScheduledActionsRequest withFilters(ScheduledActionFilter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<ScheduledActionFilter>)new SdkInternalList(filters.length));
        }
        for (ScheduledActionFilter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public DescribeScheduledActionsRequest withFilters(Collection<ScheduledActionFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeScheduledActionsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public DescribeScheduledActionsRequest withMaxRecords(Integer maxRecords) {
        this.setMaxRecords(maxRecords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScheduledActionName() != null) {
            sb.append("ScheduledActionName: ").append(this.getScheduledActionName()).append(",");
        }
        if (this.getTargetActionType() != null) {
            sb.append("TargetActionType: ").append(this.getTargetActionType()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getActive() != null) {
            sb.append("Active: ").append(this.getActive()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: ").append(this.getMaxRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsRequest)) {
            return false;
        }
        DescribeScheduledActionsRequest other = (DescribeScheduledActionsRequest)obj;
        if (other.getScheduledActionName() == null ^ this.getScheduledActionName() == null) {
            return false;
        }
        if (other.getScheduledActionName() != null && !other.getScheduledActionName().equals(this.getScheduledActionName())) {
            return false;
        }
        if (other.getTargetActionType() == null ^ this.getTargetActionType() == null) {
            return false;
        }
        if (other.getTargetActionType() != null && !other.getTargetActionType().equals(this.getTargetActionType())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getActive() == null ^ this.getActive() == null) {
            return false;
        }
        if (other.getActive() != null && !other.getActive().equals(this.getActive())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        return other.getMaxRecords() == null || other.getMaxRecords().equals(this.getMaxRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScheduledActionName() == null ? 0 : this.getScheduledActionName().hashCode());
        hashCode = 31 * hashCode + (this.getTargetActionType() == null ? 0 : this.getTargetActionType().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getActive() == null ? 0 : this.getActive().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        return hashCode;
    }

    public DescribeScheduledActionsRequest clone() {
        return (DescribeScheduledActionsRequest)super.clone();
    }
}

