/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resiliencehub.model.AppAssessmentScheduleType;
import com.amazonaws.services.resiliencehub.model.EventSubscription;
import com.amazonaws.services.resiliencehub.model.PermissionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAppRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String assessmentSchedule;
    private String clientToken;
    private String description;
    private List<EventSubscription> eventSubscriptions;
    private String name;
    private PermissionModel permissionModel;
    private String policyArn;
    private Map<String, String> tags;

    public void setAssessmentSchedule(String assessmentSchedule) {
        this.assessmentSchedule = assessmentSchedule;
    }

    public String getAssessmentSchedule() {
        return this.assessmentSchedule;
    }

    public CreateAppRequest withAssessmentSchedule(String assessmentSchedule) {
        this.setAssessmentSchedule(assessmentSchedule);
        return this;
    }

    public CreateAppRequest withAssessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
        this.assessmentSchedule = assessmentSchedule.toString();
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateAppRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateAppRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<EventSubscription> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public void setEventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
        if (eventSubscriptions == null) {
            this.eventSubscriptions = null;
            return;
        }
        this.eventSubscriptions = new ArrayList<EventSubscription>(eventSubscriptions);
    }

    public CreateAppRequest withEventSubscriptions(EventSubscription ... eventSubscriptions) {
        if (this.eventSubscriptions == null) {
            this.setEventSubscriptions(new ArrayList<EventSubscription>(eventSubscriptions.length));
        }
        for (EventSubscription ele : eventSubscriptions) {
            this.eventSubscriptions.add(ele);
        }
        return this;
    }

    public CreateAppRequest withEventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
        this.setEventSubscriptions(eventSubscriptions);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateAppRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPermissionModel(PermissionModel permissionModel) {
        this.permissionModel = permissionModel;
    }

    public PermissionModel getPermissionModel() {
        return this.permissionModel;
    }

    public CreateAppRequest withPermissionModel(PermissionModel permissionModel) {
        this.setPermissionModel(permissionModel);
        return this;
    }

    public void setPolicyArn(String policyArn) {
        this.policyArn = policyArn;
    }

    public String getPolicyArn() {
        return this.policyArn;
    }

    public CreateAppRequest withPolicyArn(String policyArn) {
        this.setPolicyArn(policyArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateAppRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateAppRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateAppRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssessmentSchedule() != null) {
            sb.append("AssessmentSchedule: ").append(this.getAssessmentSchedule()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEventSubscriptions() != null) {
            sb.append("EventSubscriptions: ").append(this.getEventSubscriptions()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPermissionModel() != null) {
            sb.append("PermissionModel: ").append(this.getPermissionModel()).append(",");
        }
        if (this.getPolicyArn() != null) {
            sb.append("PolicyArn: ").append(this.getPolicyArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)obj;
        if (other.getAssessmentSchedule() == null ^ this.getAssessmentSchedule() == null) {
            return false;
        }
        if (other.getAssessmentSchedule() != null && !other.getAssessmentSchedule().equals(this.getAssessmentSchedule())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEventSubscriptions() == null ^ this.getEventSubscriptions() == null) {
            return false;
        }
        if (other.getEventSubscriptions() != null && !other.getEventSubscriptions().equals(this.getEventSubscriptions())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPermissionModel() == null ^ this.getPermissionModel() == null) {
            return false;
        }
        if (other.getPermissionModel() != null && !other.getPermissionModel().equals(this.getPermissionModel())) {
            return false;
        }
        if (other.getPolicyArn() == null ^ this.getPolicyArn() == null) {
            return false;
        }
        if (other.getPolicyArn() != null && !other.getPolicyArn().equals(this.getPolicyArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssessmentSchedule() == null ? 0 : this.getAssessmentSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEventSubscriptions() == null ? 0 : this.getEventSubscriptions().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionModel() == null ? 0 : this.getPermissionModel().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyArn() == null ? 0 : this.getPolicyArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAppRequest clone() {
        return (CreateAppRequest)super.clone();
    }
}

