/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.ResourceError;
import com.amazonaws.services.resiliencehub.model.transform.ResourceErrorsDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourceErrorsDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean hasMoreErrors;
    private List<ResourceError> resourceErrors;

    public void setHasMoreErrors(Boolean hasMoreErrors) {
        this.hasMoreErrors = hasMoreErrors;
    }

    public Boolean getHasMoreErrors() {
        return this.hasMoreErrors;
    }

    public ResourceErrorsDetails withHasMoreErrors(Boolean hasMoreErrors) {
        this.setHasMoreErrors(hasMoreErrors);
        return this;
    }

    public Boolean isHasMoreErrors() {
        return this.hasMoreErrors;
    }

    public List<ResourceError> getResourceErrors() {
        return this.resourceErrors;
    }

    public void setResourceErrors(Collection<ResourceError> resourceErrors) {
        if (resourceErrors == null) {
            this.resourceErrors = null;
            return;
        }
        this.resourceErrors = new ArrayList<ResourceError>(resourceErrors);
    }

    public ResourceErrorsDetails withResourceErrors(ResourceError ... resourceErrors) {
        if (this.resourceErrors == null) {
            this.setResourceErrors(new ArrayList<ResourceError>(resourceErrors.length));
        }
        for (ResourceError ele : resourceErrors) {
            this.resourceErrors.add(ele);
        }
        return this;
    }

    public ResourceErrorsDetails withResourceErrors(Collection<ResourceError> resourceErrors) {
        this.setResourceErrors(resourceErrors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHasMoreErrors() != null) {
            sb.append("HasMoreErrors: ").append(this.getHasMoreErrors()).append(",");
        }
        if (this.getResourceErrors() != null) {
            sb.append("ResourceErrors: ").append(this.getResourceErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceErrorsDetails)) {
            return false;
        }
        ResourceErrorsDetails other = (ResourceErrorsDetails)obj;
        if (other.getHasMoreErrors() == null ^ this.getHasMoreErrors() == null) {
            return false;
        }
        if (other.getHasMoreErrors() != null && !other.getHasMoreErrors().equals(this.getHasMoreErrors())) {
            return false;
        }
        if (other.getResourceErrors() == null ^ this.getResourceErrors() == null) {
            return false;
        }
        return other.getResourceErrors() == null || other.getResourceErrors().equals(this.getResourceErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHasMoreErrors() == null ? 0 : this.getHasMoreErrors().hashCode());
        hashCode = 31 * hashCode + (this.getResourceErrors() == null ? 0 : this.getResourceErrors().hashCode());
        return hashCode;
    }

    public ResourceErrorsDetails clone() {
        try {
            return (ResourceErrorsDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceErrorsDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

