/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resourceexplorer2.model.IncludedProperty;
import com.amazonaws.services.resourceexplorer2.model.SearchFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateViewRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SearchFilter filters;
    private List<IncludedProperty> includedProperties;
    private String viewArn;

    public void setFilters(SearchFilter filters) {
        this.filters = filters;
    }

    public SearchFilter getFilters() {
        return this.filters;
    }

    public UpdateViewRequest withFilters(SearchFilter filters) {
        this.setFilters(filters);
        return this;
    }

    public List<IncludedProperty> getIncludedProperties() {
        return this.includedProperties;
    }

    public void setIncludedProperties(Collection<IncludedProperty> includedProperties) {
        if (includedProperties == null) {
            this.includedProperties = null;
            return;
        }
        this.includedProperties = new ArrayList<IncludedProperty>(includedProperties);
    }

    public UpdateViewRequest withIncludedProperties(IncludedProperty ... includedProperties) {
        if (this.includedProperties == null) {
            this.setIncludedProperties(new ArrayList<IncludedProperty>(includedProperties.length));
        }
        for (IncludedProperty ele : includedProperties) {
            this.includedProperties.add(ele);
        }
        return this;
    }

    public UpdateViewRequest withIncludedProperties(Collection<IncludedProperty> includedProperties) {
        this.setIncludedProperties(includedProperties);
        return this;
    }

    public void setViewArn(String viewArn) {
        this.viewArn = viewArn;
    }

    public String getViewArn() {
        return this.viewArn;
    }

    public UpdateViewRequest withViewArn(String viewArn) {
        this.setViewArn(viewArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIncludedProperties() != null) {
            sb.append("IncludedProperties: ").append(this.getIncludedProperties()).append(",");
        }
        if (this.getViewArn() != null) {
            sb.append("ViewArn: ").append(this.getViewArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateViewRequest)) {
            return false;
        }
        UpdateViewRequest other = (UpdateViewRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getIncludedProperties() == null ^ this.getIncludedProperties() == null) {
            return false;
        }
        if (other.getIncludedProperties() != null && !other.getIncludedProperties().equals(this.getIncludedProperties())) {
            return false;
        }
        if (other.getViewArn() == null ^ this.getViewArn() == null) {
            return false;
        }
        return other.getViewArn() == null || other.getViewArn().equals(this.getViewArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedProperties() == null ? 0 : this.getIncludedProperties().hashCode());
        hashCode = 31 * hashCode + (this.getViewArn() == null ? 0 : this.getViewArn().hashCode());
        return hashCode;
    }

    public UpdateViewRequest clone() {
        return (UpdateViewRequest)super.clone();
    }
}

