/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resourceexplorer2.model.IncludedProperty;
import com.amazonaws.services.resourceexplorer2.model.SearchFilter;
import com.amazonaws.services.resourceexplorer2.model.transform.ViewMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class View
implements Serializable,
Cloneable,
StructuredPojo {
    private SearchFilter filters;
    private List<IncludedProperty> includedProperties;
    private Date lastUpdatedAt;
    private String owner;
    private String scope;
    private String viewArn;

    public void setFilters(SearchFilter filters) {
        this.filters = filters;
    }

    public SearchFilter getFilters() {
        return this.filters;
    }

    public View withFilters(SearchFilter filters) {
        this.setFilters(filters);
        return this;
    }

    public List<IncludedProperty> getIncludedProperties() {
        return this.includedProperties;
    }

    public void setIncludedProperties(Collection<IncludedProperty> includedProperties) {
        if (includedProperties == null) {
            this.includedProperties = null;
            return;
        }
        this.includedProperties = new ArrayList<IncludedProperty>(includedProperties);
    }

    public View withIncludedProperties(IncludedProperty ... includedProperties) {
        if (this.includedProperties == null) {
            this.setIncludedProperties(new ArrayList<IncludedProperty>(includedProperties.length));
        }
        for (IncludedProperty ele : includedProperties) {
            this.includedProperties.add(ele);
        }
        return this;
    }

    public View withIncludedProperties(Collection<IncludedProperty> includedProperties) {
        this.setIncludedProperties(includedProperties);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public View withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public View withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public View withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public void setViewArn(String viewArn) {
        this.viewArn = viewArn;
    }

    public String getViewArn() {
        return this.viewArn;
    }

    public View withViewArn(String viewArn) {
        this.setViewArn(viewArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIncludedProperties() != null) {
            sb.append("IncludedProperties: ").append(this.getIncludedProperties()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getViewArn() != null) {
            sb.append("ViewArn: ").append(this.getViewArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof View)) {
            return false;
        }
        View other = (View)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getIncludedProperties() == null ^ this.getIncludedProperties() == null) {
            return false;
        }
        if (other.getIncludedProperties() != null && !other.getIncludedProperties().equals(this.getIncludedProperties())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getViewArn() == null ^ this.getViewArn() == null) {
            return false;
        }
        return other.getViewArn() == null || other.getViewArn().equals(this.getViewArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedProperties() == null ? 0 : this.getIncludedProperties().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getViewArn() == null ? 0 : this.getViewArn().hashCode());
        return hashCode;
    }

    public View clone() {
        try {
            return (View)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ViewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

