/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.ResourceProperty;
import java.util.Date;

@SdkInternalApi
public class ResourcePropertyMarshaller {
    private static final MarshallingInfo<Date> LASTREPORTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastReportedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final ResourcePropertyMarshaller instance = new ResourcePropertyMarshaller();

    public static ResourcePropertyMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceProperty resourceProperty, ProtocolMarshaller protocolMarshaller) {
        if (resourceProperty == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceProperty.getLastReportedAt(), LASTREPORTEDAT_BINDING);
            protocolMarshaller.marshall((Object)resourceProperty.getName(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

