/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.robomaker;

import javax.annotation.Generated;

import com.amazonaws.services.robomaker.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSRoboMaker}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSRoboMaker implements AWSRoboMaker {

    protected AbstractAWSRoboMaker() {
    }

    @Override
    public BatchDescribeSimulationJobResult batchDescribeSimulationJob(BatchDescribeSimulationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelDeploymentJobResult cancelDeploymentJob(CancelDeploymentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelSimulationJobResult cancelSimulationJob(CancelSimulationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeploymentJobResult createDeploymentJob(CreateDeploymentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFleetResult createFleet(CreateFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRobotResult createRobot(CreateRobotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRobotApplicationResult createRobotApplication(CreateRobotApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRobotApplicationVersionResult createRobotApplicationVersion(CreateRobotApplicationVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSimulationApplicationResult createSimulationApplication(CreateSimulationApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSimulationApplicationVersionResult createSimulationApplicationVersion(CreateSimulationApplicationVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSimulationJobResult createSimulationJob(CreateSimulationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFleetResult deleteFleet(DeleteFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRobotResult deleteRobot(DeleteRobotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRobotApplicationResult deleteRobotApplication(DeleteRobotApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSimulationApplicationResult deleteSimulationApplication(DeleteSimulationApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterRobotResult deregisterRobot(DeregisterRobotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDeploymentJobResult describeDeploymentJob(DescribeDeploymentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetResult describeFleet(DescribeFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRobotResult describeRobot(DescribeRobotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRobotApplicationResult describeRobotApplication(DescribeRobotApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSimulationApplicationResult describeSimulationApplication(DescribeSimulationApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSimulationJobResult describeSimulationJob(DescribeSimulationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeploymentJobsResult listDeploymentJobs(ListDeploymentJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFleetsResult listFleets(ListFleetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRobotApplicationsResult listRobotApplications(ListRobotApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRobotsResult listRobots(ListRobotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSimulationApplicationsResult listSimulationApplications(ListSimulationApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSimulationJobsResult listSimulationJobs(ListSimulationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterRobotResult registerRobot(RegisterRobotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestartSimulationJobResult restartSimulationJob(RestartSimulationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SyncDeploymentJobResult syncDeploymentJob(SyncDeploymentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRobotApplicationResult updateRobotApplication(UpdateRobotApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSimulationApplicationResult updateSimulationApplication(UpdateSimulationApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
