/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ContainerDefinition;
import java.util.Map;

@SdkInternalApi
public class ContainerDefinitionMarshaller {
    private static final MarshallingInfo<String> CONTAINERHOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainerHostname").build();
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Image").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mode").build();
    private static final MarshallingInfo<String> MODELDATAURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelDataUrl").build();
    private static final MarshallingInfo<Map> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").build();
    private static final MarshallingInfo<String> MODELPACKAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageName").build();
    private static final ContainerDefinitionMarshaller instance = new ContainerDefinitionMarshaller();

    public static ContainerDefinitionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContainerDefinition containerDefinition, ProtocolMarshaller protocolMarshaller) {
        if (containerDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)containerDefinition.getContainerHostname(), CONTAINERHOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getImage(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getMode(), MODE_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getModelDataUrl(), MODELDATAURL_BINDING);
            protocolMarshaller.marshall(containerDefinition.getEnvironment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getModelPackageName(), MODELPACKAGENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

