/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListAppImageConfigsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A token for getting the next set of AppImageConfigs, if there are any.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * A list of AppImageConfigs and their properties.
     * </p>
     */
    private java.util.List<AppImageConfigDetails> appImageConfigs;

    /**
     * <p>
     * A token for getting the next set of AppImageConfigs, if there are any.
     * </p>
     * 
     * @param nextToken
     *        A token for getting the next set of AppImageConfigs, if there are any.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token for getting the next set of AppImageConfigs, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of AppImageConfigs, if there are any.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token for getting the next set of AppImageConfigs, if there are any.
     * </p>
     * 
     * @param nextToken
     *        A token for getting the next set of AppImageConfigs, if there are any.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAppImageConfigsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * A list of AppImageConfigs and their properties.
     * </p>
     * 
     * @return A list of AppImageConfigs and their properties.
     */

    public java.util.List<AppImageConfigDetails> getAppImageConfigs() {
        return appImageConfigs;
    }

    /**
     * <p>
     * A list of AppImageConfigs and their properties.
     * </p>
     * 
     * @param appImageConfigs
     *        A list of AppImageConfigs and their properties.
     */

    public void setAppImageConfigs(java.util.Collection<AppImageConfigDetails> appImageConfigs) {
        if (appImageConfigs == null) {
            this.appImageConfigs = null;
            return;
        }

        this.appImageConfigs = new java.util.ArrayList<AppImageConfigDetails>(appImageConfigs);
    }

    /**
     * <p>
     * A list of AppImageConfigs and their properties.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAppImageConfigs(java.util.Collection)} or {@link #withAppImageConfigs(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param appImageConfigs
     *        A list of AppImageConfigs and their properties.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAppImageConfigsResult withAppImageConfigs(AppImageConfigDetails... appImageConfigs) {
        if (this.appImageConfigs == null) {
            setAppImageConfigs(new java.util.ArrayList<AppImageConfigDetails>(appImageConfigs.length));
        }
        for (AppImageConfigDetails ele : appImageConfigs) {
            this.appImageConfigs.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of AppImageConfigs and their properties.
     * </p>
     * 
     * @param appImageConfigs
     *        A list of AppImageConfigs and their properties.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAppImageConfigsResult withAppImageConfigs(java.util.Collection<AppImageConfigDetails> appImageConfigs) {
        setAppImageConfigs(appImageConfigs);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getAppImageConfigs() != null)
            sb.append("AppImageConfigs: ").append(getAppImageConfigs());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListAppImageConfigsResult == false)
            return false;
        ListAppImageConfigsResult other = (ListAppImageConfigsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getAppImageConfigs() == null ^ this.getAppImageConfigs() == null)
            return false;
        if (other.getAppImageConfigs() != null && other.getAppImageConfigs().equals(this.getAppImageConfigs()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getAppImageConfigs() == null) ? 0 : getAppImageConfigs().hashCode());
        return hashCode;
    }

    @Override
    public ListAppImageConfigsResult clone() {
        try {
            return (ListAppImageConfigsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
