/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ClarifyTextGranularity;
import com.amazonaws.services.sagemaker.model.ClarifyTextLanguage;
import com.amazonaws.services.sagemaker.model.transform.ClarifyTextConfigMarshaller;
import java.io.Serializable;

public class ClarifyTextConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String language;
    private String granularity;

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public ClarifyTextConfig withLanguage(String language) {
        this.setLanguage(language);
        return this;
    }

    public ClarifyTextConfig withLanguage(ClarifyTextLanguage language) {
        this.language = language.toString();
        return this;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public ClarifyTextConfig withGranularity(String granularity) {
        this.setGranularity(granularity);
        return this;
    }

    public ClarifyTextConfig withGranularity(ClarifyTextGranularity granularity) {
        this.granularity = granularity.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLanguage() != null) {
            sb.append("Language: ").append(this.getLanguage()).append(",");
        }
        if (this.getGranularity() != null) {
            sb.append("Granularity: ").append(this.getGranularity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyTextConfig)) {
            return false;
        }
        ClarifyTextConfig other = (ClarifyTextConfig)obj;
        if (other.getLanguage() == null ^ this.getLanguage() == null) {
            return false;
        }
        if (other.getLanguage() != null && !other.getLanguage().equals(this.getLanguage())) {
            return false;
        }
        if (other.getGranularity() == null ^ this.getGranularity() == null) {
            return false;
        }
        return other.getGranularity() == null || other.getGranularity().equals(this.getGranularity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLanguage() == null ? 0 : this.getLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getGranularity() == null ? 0 : this.getGranularity().hashCode());
        return hashCode;
    }

    public ClarifyTextConfig clone() {
        try {
            return (ClarifyTextConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClarifyTextConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

