/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.ContextSource;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateContextRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String contextName;
    private ContextSource source;
    private String contextType;
    private String description;
    private Map<String, String> properties;
    private List<Tag> tags;

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public CreateContextRequest withContextName(String contextName) {
        this.setContextName(contextName);
        return this;
    }

    public void setSource(ContextSource source) {
        this.source = source;
    }

    public ContextSource getSource() {
        return this.source;
    }

    public CreateContextRequest withSource(ContextSource source) {
        this.setSource(source);
        return this;
    }

    public void setContextType(String contextType) {
        this.contextType = contextType;
    }

    public String getContextType() {
        return this.contextType;
    }

    public CreateContextRequest withContextType(String contextType) {
        this.setContextType(contextType);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateContextRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public CreateContextRequest withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public CreateContextRequest addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public CreateContextRequest clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateContextRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateContextRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContextName() != null) {
            sb.append("ContextName: ").append(this.getContextName()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getContextType() != null) {
            sb.append("ContextType: ").append(this.getContextType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContextRequest)) {
            return false;
        }
        CreateContextRequest other = (CreateContextRequest)obj;
        if (other.getContextName() == null ^ this.getContextName() == null) {
            return false;
        }
        if (other.getContextName() != null && !other.getContextName().equals(this.getContextName())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getContextType() == null ^ this.getContextType() == null) {
            return false;
        }
        if (other.getContextType() != null && !other.getContextType().equals(this.getContextType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContextName() == null ? 0 : this.getContextName().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getContextType() == null ? 0 : this.getContextType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateContextRequest clone() {
        return (CreateContextRequest)super.clone();
    }
}

