/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.TrainingSpecification;
import java.util.List;

@SdkInternalApi
public class TrainingSpecificationMarshaller {
    private static final MarshallingInfo<String> TRAININGIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingImage").build();
    private static final MarshallingInfo<String> TRAININGIMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingImageDigest").build();
    private static final MarshallingInfo<List> SUPPORTEDHYPERPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedHyperParameters").build();
    private static final MarshallingInfo<List> SUPPORTEDTRAININGINSTANCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedTrainingInstanceTypes").build();
    private static final MarshallingInfo<Boolean> SUPPORTSDISTRIBUTEDTRAINING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportsDistributedTraining").build();
    private static final MarshallingInfo<List> METRICDEFINITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricDefinitions").build();
    private static final MarshallingInfo<List> TRAININGCHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingChannels").build();
    private static final MarshallingInfo<List> SUPPORTEDTUNINGJOBOBJECTIVEMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedTuningJobObjectiveMetrics").build();
    private static final TrainingSpecificationMarshaller instance = new TrainingSpecificationMarshaller();

    public static TrainingSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(TrainingSpecification trainingSpecification, ProtocolMarshaller protocolMarshaller) {
        if (trainingSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)trainingSpecification.getTrainingImage(), TRAININGIMAGE_BINDING);
            protocolMarshaller.marshall((Object)trainingSpecification.getTrainingImageDigest(), TRAININGIMAGEDIGEST_BINDING);
            protocolMarshaller.marshall(trainingSpecification.getSupportedHyperParameters(), SUPPORTEDHYPERPARAMETERS_BINDING);
            protocolMarshaller.marshall(trainingSpecification.getSupportedTrainingInstanceTypes(), SUPPORTEDTRAININGINSTANCETYPES_BINDING);
            protocolMarshaller.marshall((Object)trainingSpecification.getSupportsDistributedTraining(), SUPPORTSDISTRIBUTEDTRAINING_BINDING);
            protocolMarshaller.marshall(trainingSpecification.getMetricDefinitions(), METRICDEFINITIONS_BINDING);
            protocolMarshaller.marshall(trainingSpecification.getTrainingChannels(), TRAININGCHANNELS_BINDING);
            protocolMarshaller.marshall(trainingSpecification.getSupportedTuningJobObjectiveMetrics(), SUPPORTEDTUNINGJOBOBJECTIVEMETRICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

