/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.Model;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ModelMarshaller {
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").build();
    private static final MarshallingInfo<StructuredPojo> PRIMARYCONTAINER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrimaryContainer").build();
    private static final MarshallingInfo<List> CONTAINERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Containers").build();
    private static final MarshallingInfo<StructuredPojo> INFERENCEEXECUTIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InferenceExecutionConfig").build();
    private static final MarshallingInfo<String> EXECUTIONROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionRoleArn").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> MODELARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelArn").build();
    private static final MarshallingInfo<Boolean> ENABLENETWORKISOLATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableNetworkIsolation").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final ModelMarshaller instance = new ModelMarshaller();

    public static ModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(Model model, ProtocolMarshaller protocolMarshaller) {
        if (model == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)model.getModelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)model.getPrimaryContainer(), PRIMARYCONTAINER_BINDING);
            protocolMarshaller.marshall(model.getContainers(), CONTAINERS_BINDING);
            protocolMarshaller.marshall((Object)model.getInferenceExecutionConfig(), INFERENCEEXECUTIONCONFIG_BINDING);
            protocolMarshaller.marshall((Object)model.getExecutionRoleArn(), EXECUTIONROLEARN_BINDING);
            protocolMarshaller.marshall((Object)model.getVpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)model.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)model.getModelArn(), MODELARN_BINDING);
            protocolMarshaller.marshall((Object)model.getEnableNetworkIsolation(), ENABLENETWORKISOLATION_BINDING);
            protocolMarshaller.marshall(model.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

