/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.ProfilerConfigForUpdate;
import com.amazonaws.services.sagemaker.model.ProfilerRuleConfiguration;
import com.amazonaws.services.sagemaker.model.ResourceConfigForUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateTrainingJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String trainingJobName;
    private ProfilerConfigForUpdate profilerConfig;
    private List<ProfilerRuleConfiguration> profilerRuleConfigurations;
    private ResourceConfigForUpdate resourceConfig;

    public void setTrainingJobName(String trainingJobName) {
        this.trainingJobName = trainingJobName;
    }

    public String getTrainingJobName() {
        return this.trainingJobName;
    }

    public UpdateTrainingJobRequest withTrainingJobName(String trainingJobName) {
        this.setTrainingJobName(trainingJobName);
        return this;
    }

    public void setProfilerConfig(ProfilerConfigForUpdate profilerConfig) {
        this.profilerConfig = profilerConfig;
    }

    public ProfilerConfigForUpdate getProfilerConfig() {
        return this.profilerConfig;
    }

    public UpdateTrainingJobRequest withProfilerConfig(ProfilerConfigForUpdate profilerConfig) {
        this.setProfilerConfig(profilerConfig);
        return this;
    }

    public List<ProfilerRuleConfiguration> getProfilerRuleConfigurations() {
        return this.profilerRuleConfigurations;
    }

    public void setProfilerRuleConfigurations(Collection<ProfilerRuleConfiguration> profilerRuleConfigurations) {
        if (profilerRuleConfigurations == null) {
            this.profilerRuleConfigurations = null;
            return;
        }
        this.profilerRuleConfigurations = new ArrayList<ProfilerRuleConfiguration>(profilerRuleConfigurations);
    }

    public UpdateTrainingJobRequest withProfilerRuleConfigurations(ProfilerRuleConfiguration ... profilerRuleConfigurations) {
        if (this.profilerRuleConfigurations == null) {
            this.setProfilerRuleConfigurations(new ArrayList<ProfilerRuleConfiguration>(profilerRuleConfigurations.length));
        }
        for (ProfilerRuleConfiguration ele : profilerRuleConfigurations) {
            this.profilerRuleConfigurations.add(ele);
        }
        return this;
    }

    public UpdateTrainingJobRequest withProfilerRuleConfigurations(Collection<ProfilerRuleConfiguration> profilerRuleConfigurations) {
        this.setProfilerRuleConfigurations(profilerRuleConfigurations);
        return this;
    }

    public void setResourceConfig(ResourceConfigForUpdate resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public ResourceConfigForUpdate getResourceConfig() {
        return this.resourceConfig;
    }

    public UpdateTrainingJobRequest withResourceConfig(ResourceConfigForUpdate resourceConfig) {
        this.setResourceConfig(resourceConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrainingJobName() != null) {
            sb.append("TrainingJobName: ").append(this.getTrainingJobName()).append(",");
        }
        if (this.getProfilerConfig() != null) {
            sb.append("ProfilerConfig: ").append(this.getProfilerConfig()).append(",");
        }
        if (this.getProfilerRuleConfigurations() != null) {
            sb.append("ProfilerRuleConfigurations: ").append(this.getProfilerRuleConfigurations()).append(",");
        }
        if (this.getResourceConfig() != null) {
            sb.append("ResourceConfig: ").append(this.getResourceConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrainingJobRequest)) {
            return false;
        }
        UpdateTrainingJobRequest other = (UpdateTrainingJobRequest)obj;
        if (other.getTrainingJobName() == null ^ this.getTrainingJobName() == null) {
            return false;
        }
        if (other.getTrainingJobName() != null && !other.getTrainingJobName().equals(this.getTrainingJobName())) {
            return false;
        }
        if (other.getProfilerConfig() == null ^ this.getProfilerConfig() == null) {
            return false;
        }
        if (other.getProfilerConfig() != null && !other.getProfilerConfig().equals(this.getProfilerConfig())) {
            return false;
        }
        if (other.getProfilerRuleConfigurations() == null ^ this.getProfilerRuleConfigurations() == null) {
            return false;
        }
        if (other.getProfilerRuleConfigurations() != null && !other.getProfilerRuleConfigurations().equals(this.getProfilerRuleConfigurations())) {
            return false;
        }
        if (other.getResourceConfig() == null ^ this.getResourceConfig() == null) {
            return false;
        }
        return other.getResourceConfig() == null || other.getResourceConfig().equals(this.getResourceConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrainingJobName() == null ? 0 : this.getTrainingJobName().hashCode());
        hashCode = 31 * hashCode + (this.getProfilerConfig() == null ? 0 : this.getProfilerConfig().hashCode());
        hashCode = 31 * hashCode + (this.getProfilerRuleConfigurations() == null ? 0 : this.getProfilerRuleConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getResourceConfig() == null ? 0 : this.getResourceConfig().hashCode());
        return hashCode;
    }

    public UpdateTrainingJobRequest clone() {
        return (UpdateTrainingJobRequest)super.clone();
    }
}

