/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CollectionConfiguration;
import com.amazonaws.services.sagemaker.model.transform.DebugHookConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DebugHookConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String localPath;
    private String s3OutputPath;
    private Map<String, String> hookParameters;
    private List<CollectionConfiguration> collectionConfigurations;

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public DebugHookConfig withLocalPath(String localPath) {
        this.setLocalPath(localPath);
        return this;
    }

    public void setS3OutputPath(String s3OutputPath) {
        this.s3OutputPath = s3OutputPath;
    }

    public String getS3OutputPath() {
        return this.s3OutputPath;
    }

    public DebugHookConfig withS3OutputPath(String s3OutputPath) {
        this.setS3OutputPath(s3OutputPath);
        return this;
    }

    public Map<String, String> getHookParameters() {
        return this.hookParameters;
    }

    public void setHookParameters(Map<String, String> hookParameters) {
        this.hookParameters = hookParameters;
    }

    public DebugHookConfig withHookParameters(Map<String, String> hookParameters) {
        this.setHookParameters(hookParameters);
        return this;
    }

    public DebugHookConfig addHookParametersEntry(String key, String value) {
        if (null == this.hookParameters) {
            this.hookParameters = new HashMap<String, String>();
        }
        if (this.hookParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.hookParameters.put(key, value);
        return this;
    }

    public DebugHookConfig clearHookParametersEntries() {
        this.hookParameters = null;
        return this;
    }

    public List<CollectionConfiguration> getCollectionConfigurations() {
        return this.collectionConfigurations;
    }

    public void setCollectionConfigurations(Collection<CollectionConfiguration> collectionConfigurations) {
        if (collectionConfigurations == null) {
            this.collectionConfigurations = null;
            return;
        }
        this.collectionConfigurations = new ArrayList<CollectionConfiguration>(collectionConfigurations);
    }

    public DebugHookConfig withCollectionConfigurations(CollectionConfiguration ... collectionConfigurations) {
        if (this.collectionConfigurations == null) {
            this.setCollectionConfigurations(new ArrayList<CollectionConfiguration>(collectionConfigurations.length));
        }
        for (CollectionConfiguration ele : collectionConfigurations) {
            this.collectionConfigurations.add(ele);
        }
        return this;
    }

    public DebugHookConfig withCollectionConfigurations(Collection<CollectionConfiguration> collectionConfigurations) {
        this.setCollectionConfigurations(collectionConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLocalPath() != null) {
            sb.append("LocalPath: ").append(this.getLocalPath()).append(",");
        }
        if (this.getS3OutputPath() != null) {
            sb.append("S3OutputPath: ").append(this.getS3OutputPath()).append(",");
        }
        if (this.getHookParameters() != null) {
            sb.append("HookParameters: ").append(this.getHookParameters()).append(",");
        }
        if (this.getCollectionConfigurations() != null) {
            sb.append("CollectionConfigurations: ").append(this.getCollectionConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DebugHookConfig)) {
            return false;
        }
        DebugHookConfig other = (DebugHookConfig)obj;
        if (other.getLocalPath() == null ^ this.getLocalPath() == null) {
            return false;
        }
        if (other.getLocalPath() != null && !other.getLocalPath().equals(this.getLocalPath())) {
            return false;
        }
        if (other.getS3OutputPath() == null ^ this.getS3OutputPath() == null) {
            return false;
        }
        if (other.getS3OutputPath() != null && !other.getS3OutputPath().equals(this.getS3OutputPath())) {
            return false;
        }
        if (other.getHookParameters() == null ^ this.getHookParameters() == null) {
            return false;
        }
        if (other.getHookParameters() != null && !other.getHookParameters().equals(this.getHookParameters())) {
            return false;
        }
        if (other.getCollectionConfigurations() == null ^ this.getCollectionConfigurations() == null) {
            return false;
        }
        return other.getCollectionConfigurations() == null || other.getCollectionConfigurations().equals(this.getCollectionConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLocalPath() == null ? 0 : this.getLocalPath().hashCode());
        hashCode = 31 * hashCode + (this.getS3OutputPath() == null ? 0 : this.getS3OutputPath().hashCode());
        hashCode = 31 * hashCode + (this.getHookParameters() == null ? 0 : this.getHookParameters().hashCode());
        hashCode = 31 * hashCode + (this.getCollectionConfigurations() == null ? 0 : this.getCollectionConfigurations().hashCode());
        return hashCode;
    }

    public DebugHookConfig clone() {
        try {
            return (DebugHookConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DebugHookConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

