/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.HubS3StorageConfig;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateHubRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String hubName;
    private String hubDescription;
    private String hubDisplayName;
    private List<String> hubSearchKeywords;
    private HubS3StorageConfig s3StorageConfig;
    private List<Tag> tags;

    public void setHubName(String hubName) {
        this.hubName = hubName;
    }

    public String getHubName() {
        return this.hubName;
    }

    public CreateHubRequest withHubName(String hubName) {
        this.setHubName(hubName);
        return this;
    }

    public void setHubDescription(String hubDescription) {
        this.hubDescription = hubDescription;
    }

    public String getHubDescription() {
        return this.hubDescription;
    }

    public CreateHubRequest withHubDescription(String hubDescription) {
        this.setHubDescription(hubDescription);
        return this;
    }

    public void setHubDisplayName(String hubDisplayName) {
        this.hubDisplayName = hubDisplayName;
    }

    public String getHubDisplayName() {
        return this.hubDisplayName;
    }

    public CreateHubRequest withHubDisplayName(String hubDisplayName) {
        this.setHubDisplayName(hubDisplayName);
        return this;
    }

    public List<String> getHubSearchKeywords() {
        return this.hubSearchKeywords;
    }

    public void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
        if (hubSearchKeywords == null) {
            this.hubSearchKeywords = null;
            return;
        }
        this.hubSearchKeywords = new ArrayList<String>(hubSearchKeywords);
    }

    public CreateHubRequest withHubSearchKeywords(String ... hubSearchKeywords) {
        if (this.hubSearchKeywords == null) {
            this.setHubSearchKeywords(new ArrayList<String>(hubSearchKeywords.length));
        }
        for (String ele : hubSearchKeywords) {
            this.hubSearchKeywords.add(ele);
        }
        return this;
    }

    public CreateHubRequest withHubSearchKeywords(Collection<String> hubSearchKeywords) {
        this.setHubSearchKeywords(hubSearchKeywords);
        return this;
    }

    public void setS3StorageConfig(HubS3StorageConfig s3StorageConfig) {
        this.s3StorageConfig = s3StorageConfig;
    }

    public HubS3StorageConfig getS3StorageConfig() {
        return this.s3StorageConfig;
    }

    public CreateHubRequest withS3StorageConfig(HubS3StorageConfig s3StorageConfig) {
        this.setS3StorageConfig(s3StorageConfig);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateHubRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateHubRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHubName() != null) {
            sb.append("HubName: ").append(this.getHubName()).append(",");
        }
        if (this.getHubDescription() != null) {
            sb.append("HubDescription: ").append(this.getHubDescription()).append(",");
        }
        if (this.getHubDisplayName() != null) {
            sb.append("HubDisplayName: ").append(this.getHubDisplayName()).append(",");
        }
        if (this.getHubSearchKeywords() != null) {
            sb.append("HubSearchKeywords: ").append(this.getHubSearchKeywords()).append(",");
        }
        if (this.getS3StorageConfig() != null) {
            sb.append("S3StorageConfig: ").append(this.getS3StorageConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubRequest)) {
            return false;
        }
        CreateHubRequest other = (CreateHubRequest)obj;
        if (other.getHubName() == null ^ this.getHubName() == null) {
            return false;
        }
        if (other.getHubName() != null && !other.getHubName().equals(this.getHubName())) {
            return false;
        }
        if (other.getHubDescription() == null ^ this.getHubDescription() == null) {
            return false;
        }
        if (other.getHubDescription() != null && !other.getHubDescription().equals(this.getHubDescription())) {
            return false;
        }
        if (other.getHubDisplayName() == null ^ this.getHubDisplayName() == null) {
            return false;
        }
        if (other.getHubDisplayName() != null && !other.getHubDisplayName().equals(this.getHubDisplayName())) {
            return false;
        }
        if (other.getHubSearchKeywords() == null ^ this.getHubSearchKeywords() == null) {
            return false;
        }
        if (other.getHubSearchKeywords() != null && !other.getHubSearchKeywords().equals(this.getHubSearchKeywords())) {
            return false;
        }
        if (other.getS3StorageConfig() == null ^ this.getS3StorageConfig() == null) {
            return false;
        }
        if (other.getS3StorageConfig() != null && !other.getS3StorageConfig().equals(this.getS3StorageConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHubName() == null ? 0 : this.getHubName().hashCode());
        hashCode = 31 * hashCode + (this.getHubDescription() == null ? 0 : this.getHubDescription().hashCode());
        hashCode = 31 * hashCode + (this.getHubDisplayName() == null ? 0 : this.getHubDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getHubSearchKeywords() == null ? 0 : this.getHubSearchKeywords().hashCode());
        hashCode = 31 * hashCode + (this.getS3StorageConfig() == null ? 0 : this.getS3StorageConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateHubRequest clone() {
        return (CreateHubRequest)super.clone();
    }
}

