/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.InferenceExperimentStopDesiredState;
import com.amazonaws.services.sagemaker.model.ModelVariantConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StopInferenceExperimentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private Map<String, String> modelVariantActions;
    private List<ModelVariantConfig> desiredModelVariants;
    private String desiredState;
    private String reason;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public StopInferenceExperimentRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, String> getModelVariantActions() {
        return this.modelVariantActions;
    }

    public void setModelVariantActions(Map<String, String> modelVariantActions) {
        this.modelVariantActions = modelVariantActions;
    }

    public StopInferenceExperimentRequest withModelVariantActions(Map<String, String> modelVariantActions) {
        this.setModelVariantActions(modelVariantActions);
        return this;
    }

    public StopInferenceExperimentRequest addModelVariantActionsEntry(String key, String value) {
        if (null == this.modelVariantActions) {
            this.modelVariantActions = new HashMap<String, String>();
        }
        if (this.modelVariantActions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.modelVariantActions.put(key, value);
        return this;
    }

    public StopInferenceExperimentRequest clearModelVariantActionsEntries() {
        this.modelVariantActions = null;
        return this;
    }

    public List<ModelVariantConfig> getDesiredModelVariants() {
        return this.desiredModelVariants;
    }

    public void setDesiredModelVariants(Collection<ModelVariantConfig> desiredModelVariants) {
        if (desiredModelVariants == null) {
            this.desiredModelVariants = null;
            return;
        }
        this.desiredModelVariants = new ArrayList<ModelVariantConfig>(desiredModelVariants);
    }

    public StopInferenceExperimentRequest withDesiredModelVariants(ModelVariantConfig ... desiredModelVariants) {
        if (this.desiredModelVariants == null) {
            this.setDesiredModelVariants(new ArrayList<ModelVariantConfig>(desiredModelVariants.length));
        }
        for (ModelVariantConfig ele : desiredModelVariants) {
            this.desiredModelVariants.add(ele);
        }
        return this;
    }

    public StopInferenceExperimentRequest withDesiredModelVariants(Collection<ModelVariantConfig> desiredModelVariants) {
        this.setDesiredModelVariants(desiredModelVariants);
        return this;
    }

    public void setDesiredState(String desiredState) {
        this.desiredState = desiredState;
    }

    public String getDesiredState() {
        return this.desiredState;
    }

    public StopInferenceExperimentRequest withDesiredState(String desiredState) {
        this.setDesiredState(desiredState);
        return this;
    }

    public StopInferenceExperimentRequest withDesiredState(InferenceExperimentStopDesiredState desiredState) {
        this.desiredState = desiredState.toString();
        return this;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public StopInferenceExperimentRequest withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getModelVariantActions() != null) {
            sb.append("ModelVariantActions: ").append(this.getModelVariantActions()).append(",");
        }
        if (this.getDesiredModelVariants() != null) {
            sb.append("DesiredModelVariants: ").append(this.getDesiredModelVariants()).append(",");
        }
        if (this.getDesiredState() != null) {
            sb.append("DesiredState: ").append(this.getDesiredState()).append(",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: ").append(this.getReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInferenceExperimentRequest)) {
            return false;
        }
        StopInferenceExperimentRequest other = (StopInferenceExperimentRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getModelVariantActions() == null ^ this.getModelVariantActions() == null) {
            return false;
        }
        if (other.getModelVariantActions() != null && !other.getModelVariantActions().equals(this.getModelVariantActions())) {
            return false;
        }
        if (other.getDesiredModelVariants() == null ^ this.getDesiredModelVariants() == null) {
            return false;
        }
        if (other.getDesiredModelVariants() != null && !other.getDesiredModelVariants().equals(this.getDesiredModelVariants())) {
            return false;
        }
        if (other.getDesiredState() == null ^ this.getDesiredState() == null) {
            return false;
        }
        if (other.getDesiredState() != null && !other.getDesiredState().equals(this.getDesiredState())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        return other.getReason() == null || other.getReason().equals(this.getReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getModelVariantActions() == null ? 0 : this.getModelVariantActions().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredModelVariants() == null ? 0 : this.getDesiredModelVariants().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredState() == null ? 0 : this.getDesiredState().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        return hashCode;
    }

    public StopInferenceExperimentRequest clone() {
        return (StopInferenceExperimentRequest)super.clone();
    }
}

