/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.AwsEc2NetworkInterfaceAttachment;
import com.amazonaws.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup;
import com.amazonaws.services.securityhub.model.transform.AwsEc2NetworkInterfaceDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AwsEc2NetworkInterfaceDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private AwsEc2NetworkInterfaceAttachment attachment;
    private String networkInterfaceId;
    private List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups;
    private Boolean sourceDestCheck;

    public void setAttachment(AwsEc2NetworkInterfaceAttachment attachment) {
        this.attachment = attachment;
    }

    public AwsEc2NetworkInterfaceAttachment getAttachment() {
        return this.attachment;
    }

    public AwsEc2NetworkInterfaceDetails withAttachment(AwsEc2NetworkInterfaceAttachment attachment) {
        this.setAttachment(attachment);
        return this;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public AwsEc2NetworkInterfaceDetails withNetworkInterfaceId(String networkInterfaceId) {
        this.setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    public List<AwsEc2NetworkInterfaceSecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<AwsEc2NetworkInterfaceSecurityGroup>(securityGroups);
    }

    public AwsEc2NetworkInterfaceDetails withSecurityGroups(AwsEc2NetworkInterfaceSecurityGroup ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<AwsEc2NetworkInterfaceSecurityGroup>(securityGroups.length));
        }
        for (AwsEc2NetworkInterfaceSecurityGroup ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public AwsEc2NetworkInterfaceDetails withSecurityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public AwsEc2NetworkInterfaceDetails withSourceDestCheck(Boolean sourceDestCheck) {
        this.setSourceDestCheck(sourceDestCheck);
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttachment() != null) {
            sb.append("Attachment: ").append(this.getAttachment()).append(",");
        }
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.getNetworkInterfaceId()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getSourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.getSourceDestCheck());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceDetails)) {
            return false;
        }
        AwsEc2NetworkInterfaceDetails other = (AwsEc2NetworkInterfaceDetails)obj;
        if (other.getAttachment() == null ^ this.getAttachment() == null) {
            return false;
        }
        if (other.getAttachment() != null && !other.getAttachment().equals(this.getAttachment())) {
            return false;
        }
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getSourceDestCheck() == null ^ this.getSourceDestCheck() == null) {
            return false;
        }
        return other.getSourceDestCheck() == null || other.getSourceDestCheck().equals(this.getSourceDestCheck());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttachment() == null ? 0 : this.getAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDestCheck() == null ? 0 : this.getSourceDestCheck().hashCode());
        return hashCode;
    }

    public AwsEc2NetworkInterfaceDetails clone() {
        try {
            return (AwsEc2NetworkInterfaceDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AwsEc2NetworkInterfaceDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

