/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A vulnerability associated with a finding.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Vulnerability" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Vulnerability implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The identifier of the vulnerability.
     * </p>
     */
    private String id;
    /**
     * <p>
     * List of software packages that have the vulnerability.
     * </p>
     */
    private java.util.List<SoftwarePackage> vulnerablePackages;
    /**
     * <p>
     * CVSS scores from the advisory related to the vulnerability.
     * </p>
     */
    private java.util.List<Cvss> cvss;
    /**
     * <p>
     * List of vulnerabilities that are related to this vulnerability.
     * </p>
     */
    private java.util.List<String> relatedVulnerabilities;
    /**
     * <p>
     * Information about the vendor that generates the vulnerability report.
     * </p>
     */
    private VulnerabilityVendor vendor;
    /**
     * <p>
     * A list of URLs that provide additional information about the vulnerability.
     * </p>
     */
    private java.util.List<String> referenceUrls;

    /**
     * <p>
     * The identifier of the vulnerability.
     * </p>
     * 
     * @param id
     *        The identifier of the vulnerability.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The identifier of the vulnerability.
     * </p>
     * 
     * @return The identifier of the vulnerability.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The identifier of the vulnerability.
     * </p>
     * 
     * @param id
     *        The identifier of the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * List of software packages that have the vulnerability.
     * </p>
     * 
     * @return List of software packages that have the vulnerability.
     */

    public java.util.List<SoftwarePackage> getVulnerablePackages() {
        return vulnerablePackages;
    }

    /**
     * <p>
     * List of software packages that have the vulnerability.
     * </p>
     * 
     * @param vulnerablePackages
     *        List of software packages that have the vulnerability.
     */

    public void setVulnerablePackages(java.util.Collection<SoftwarePackage> vulnerablePackages) {
        if (vulnerablePackages == null) {
            this.vulnerablePackages = null;
            return;
        }

        this.vulnerablePackages = new java.util.ArrayList<SoftwarePackage>(vulnerablePackages);
    }

    /**
     * <p>
     * List of software packages that have the vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setVulnerablePackages(java.util.Collection)} or {@link #withVulnerablePackages(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param vulnerablePackages
     *        List of software packages that have the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withVulnerablePackages(SoftwarePackage... vulnerablePackages) {
        if (this.vulnerablePackages == null) {
            setVulnerablePackages(new java.util.ArrayList<SoftwarePackage>(vulnerablePackages.length));
        }
        for (SoftwarePackage ele : vulnerablePackages) {
            this.vulnerablePackages.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List of software packages that have the vulnerability.
     * </p>
     * 
     * @param vulnerablePackages
     *        List of software packages that have the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withVulnerablePackages(java.util.Collection<SoftwarePackage> vulnerablePackages) {
        setVulnerablePackages(vulnerablePackages);
        return this;
    }

    /**
     * <p>
     * CVSS scores from the advisory related to the vulnerability.
     * </p>
     * 
     * @return CVSS scores from the advisory related to the vulnerability.
     */

    public java.util.List<Cvss> getCvss() {
        return cvss;
    }

    /**
     * <p>
     * CVSS scores from the advisory related to the vulnerability.
     * </p>
     * 
     * @param cvss
     *        CVSS scores from the advisory related to the vulnerability.
     */

    public void setCvss(java.util.Collection<Cvss> cvss) {
        if (cvss == null) {
            this.cvss = null;
            return;
        }

        this.cvss = new java.util.ArrayList<Cvss>(cvss);
    }

    /**
     * <p>
     * CVSS scores from the advisory related to the vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCvss(java.util.Collection)} or {@link #withCvss(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param cvss
     *        CVSS scores from the advisory related to the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withCvss(Cvss... cvss) {
        if (this.cvss == null) {
            setCvss(new java.util.ArrayList<Cvss>(cvss.length));
        }
        for (Cvss ele : cvss) {
            this.cvss.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * CVSS scores from the advisory related to the vulnerability.
     * </p>
     * 
     * @param cvss
     *        CVSS scores from the advisory related to the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withCvss(java.util.Collection<Cvss> cvss) {
        setCvss(cvss);
        return this;
    }

    /**
     * <p>
     * List of vulnerabilities that are related to this vulnerability.
     * </p>
     * 
     * @return List of vulnerabilities that are related to this vulnerability.
     */

    public java.util.List<String> getRelatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    /**
     * <p>
     * List of vulnerabilities that are related to this vulnerability.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        List of vulnerabilities that are related to this vulnerability.
     */

    public void setRelatedVulnerabilities(java.util.Collection<String> relatedVulnerabilities) {
        if (relatedVulnerabilities == null) {
            this.relatedVulnerabilities = null;
            return;
        }

        this.relatedVulnerabilities = new java.util.ArrayList<String>(relatedVulnerabilities);
    }

    /**
     * <p>
     * List of vulnerabilities that are related to this vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRelatedVulnerabilities(java.util.Collection)} or
     * {@link #withRelatedVulnerabilities(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        List of vulnerabilities that are related to this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withRelatedVulnerabilities(String... relatedVulnerabilities) {
        if (this.relatedVulnerabilities == null) {
            setRelatedVulnerabilities(new java.util.ArrayList<String>(relatedVulnerabilities.length));
        }
        for (String ele : relatedVulnerabilities) {
            this.relatedVulnerabilities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List of vulnerabilities that are related to this vulnerability.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        List of vulnerabilities that are related to this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withRelatedVulnerabilities(java.util.Collection<String> relatedVulnerabilities) {
        setRelatedVulnerabilities(relatedVulnerabilities);
        return this;
    }

    /**
     * <p>
     * Information about the vendor that generates the vulnerability report.
     * </p>
     * 
     * @param vendor
     *        Information about the vendor that generates the vulnerability report.
     */

    public void setVendor(VulnerabilityVendor vendor) {
        this.vendor = vendor;
    }

    /**
     * <p>
     * Information about the vendor that generates the vulnerability report.
     * </p>
     * 
     * @return Information about the vendor that generates the vulnerability report.
     */

    public VulnerabilityVendor getVendor() {
        return this.vendor;
    }

    /**
     * <p>
     * Information about the vendor that generates the vulnerability report.
     * </p>
     * 
     * @param vendor
     *        Information about the vendor that generates the vulnerability report.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withVendor(VulnerabilityVendor vendor) {
        setVendor(vendor);
        return this;
    }

    /**
     * <p>
     * A list of URLs that provide additional information about the vulnerability.
     * </p>
     * 
     * @return A list of URLs that provide additional information about the vulnerability.
     */

    public java.util.List<String> getReferenceUrls() {
        return referenceUrls;
    }

    /**
     * <p>
     * A list of URLs that provide additional information about the vulnerability.
     * </p>
     * 
     * @param referenceUrls
     *        A list of URLs that provide additional information about the vulnerability.
     */

    public void setReferenceUrls(java.util.Collection<String> referenceUrls) {
        if (referenceUrls == null) {
            this.referenceUrls = null;
            return;
        }

        this.referenceUrls = new java.util.ArrayList<String>(referenceUrls);
    }

    /**
     * <p>
     * A list of URLs that provide additional information about the vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setReferenceUrls(java.util.Collection)} or {@link #withReferenceUrls(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param referenceUrls
     *        A list of URLs that provide additional information about the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withReferenceUrls(String... referenceUrls) {
        if (this.referenceUrls == null) {
            setReferenceUrls(new java.util.ArrayList<String>(referenceUrls.length));
        }
        for (String ele : referenceUrls) {
            this.referenceUrls.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of URLs that provide additional information about the vulnerability.
     * </p>
     * 
     * @param referenceUrls
     *        A list of URLs that provide additional information about the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withReferenceUrls(java.util.Collection<String> referenceUrls) {
        setReferenceUrls(referenceUrls);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getVulnerablePackages() != null)
            sb.append("VulnerablePackages: ").append(getVulnerablePackages()).append(",");
        if (getCvss() != null)
            sb.append("Cvss: ").append(getCvss()).append(",");
        if (getRelatedVulnerabilities() != null)
            sb.append("RelatedVulnerabilities: ").append(getRelatedVulnerabilities()).append(",");
        if (getVendor() != null)
            sb.append("Vendor: ").append(getVendor()).append(",");
        if (getReferenceUrls() != null)
            sb.append("ReferenceUrls: ").append(getReferenceUrls());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Vulnerability == false)
            return false;
        Vulnerability other = (Vulnerability) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getVulnerablePackages() == null ^ this.getVulnerablePackages() == null)
            return false;
        if (other.getVulnerablePackages() != null && other.getVulnerablePackages().equals(this.getVulnerablePackages()) == false)
            return false;
        if (other.getCvss() == null ^ this.getCvss() == null)
            return false;
        if (other.getCvss() != null && other.getCvss().equals(this.getCvss()) == false)
            return false;
        if (other.getRelatedVulnerabilities() == null ^ this.getRelatedVulnerabilities() == null)
            return false;
        if (other.getRelatedVulnerabilities() != null && other.getRelatedVulnerabilities().equals(this.getRelatedVulnerabilities()) == false)
            return false;
        if (other.getVendor() == null ^ this.getVendor() == null)
            return false;
        if (other.getVendor() != null && other.getVendor().equals(this.getVendor()) == false)
            return false;
        if (other.getReferenceUrls() == null ^ this.getReferenceUrls() == null)
            return false;
        if (other.getReferenceUrls() != null && other.getReferenceUrls().equals(this.getReferenceUrls()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getVulnerablePackages() == null) ? 0 : getVulnerablePackages().hashCode());
        hashCode = prime * hashCode + ((getCvss() == null) ? 0 : getCvss().hashCode());
        hashCode = prime * hashCode + ((getRelatedVulnerabilities() == null) ? 0 : getRelatedVulnerabilities().hashCode());
        hashCode = prime * hashCode + ((getVendor() == null) ? 0 : getVendor().hashCode());
        hashCode = prime * hashCode + ((getReferenceUrls() == null) ? 0 : getReferenceUrls().hashCode());
        return hashCode;
    }

    @Override
    public Vulnerability clone() {
        try {
            return (Vulnerability) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.VulnerabilityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
