/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.securityhub.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetailsJsonUnmarshaller implements
        Unmarshaller<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails, JsonUnmarshallerContext> {

    public AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails awsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails = new AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Operands", targetDepth)) {
                    context.nextToken();
                    awsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
                            .setOperands(new ListUnmarshaller<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>(
                                    AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetailsJsonUnmarshaller.getInstance())

                            .unmarshall(context));
                }
                if (context.testExpression("Prefix", targetDepth)) {
                    context.nextToken();
                    awsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.setPrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Tag", targetDepth)) {
                    context.nextToken();
                    awsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
                            .setTag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    awsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.setType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return awsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails;
    }

    private static AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetailsJsonUnmarshaller instance;

    public static AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetailsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetailsJsonUnmarshaller();
        return instance;
    }
}
