/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.Cell;
import com.amazonaws.services.securityhub.model.Page;
import com.amazonaws.services.securityhub.model.Range;
import com.amazonaws.services.securityhub.model.Record;
import com.amazonaws.services.securityhub.model.transform.OccurrencesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Occurrences
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Range> lineRanges;
    private List<Range> offsetRanges;
    private List<Page> pages;
    private List<Record> records;
    private List<Cell> cells;

    public List<Range> getLineRanges() {
        return this.lineRanges;
    }

    public void setLineRanges(Collection<Range> lineRanges) {
        if (lineRanges == null) {
            this.lineRanges = null;
            return;
        }
        this.lineRanges = new ArrayList<Range>(lineRanges);
    }

    public Occurrences withLineRanges(Range ... lineRanges) {
        if (this.lineRanges == null) {
            this.setLineRanges(new ArrayList<Range>(lineRanges.length));
        }
        for (Range ele : lineRanges) {
            this.lineRanges.add(ele);
        }
        return this;
    }

    public Occurrences withLineRanges(Collection<Range> lineRanges) {
        this.setLineRanges(lineRanges);
        return this;
    }

    public List<Range> getOffsetRanges() {
        return this.offsetRanges;
    }

    public void setOffsetRanges(Collection<Range> offsetRanges) {
        if (offsetRanges == null) {
            this.offsetRanges = null;
            return;
        }
        this.offsetRanges = new ArrayList<Range>(offsetRanges);
    }

    public Occurrences withOffsetRanges(Range ... offsetRanges) {
        if (this.offsetRanges == null) {
            this.setOffsetRanges(new ArrayList<Range>(offsetRanges.length));
        }
        for (Range ele : offsetRanges) {
            this.offsetRanges.add(ele);
        }
        return this;
    }

    public Occurrences withOffsetRanges(Collection<Range> offsetRanges) {
        this.setOffsetRanges(offsetRanges);
        return this;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public void setPages(Collection<Page> pages) {
        if (pages == null) {
            this.pages = null;
            return;
        }
        this.pages = new ArrayList<Page>(pages);
    }

    public Occurrences withPages(Page ... pages) {
        if (this.pages == null) {
            this.setPages(new ArrayList<Page>(pages.length));
        }
        for (Page ele : pages) {
            this.pages.add(ele);
        }
        return this;
    }

    public Occurrences withPages(Collection<Page> pages) {
        this.setPages(pages);
        return this;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        this.records = new ArrayList<Record>(records);
    }

    public Occurrences withRecords(Record ... records) {
        if (this.records == null) {
            this.setRecords(new ArrayList<Record>(records.length));
        }
        for (Record ele : records) {
            this.records.add(ele);
        }
        return this;
    }

    public Occurrences withRecords(Collection<Record> records) {
        this.setRecords(records);
        return this;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setCells(Collection<Cell> cells) {
        if (cells == null) {
            this.cells = null;
            return;
        }
        this.cells = new ArrayList<Cell>(cells);
    }

    public Occurrences withCells(Cell ... cells) {
        if (this.cells == null) {
            this.setCells(new ArrayList<Cell>(cells.length));
        }
        for (Cell ele : cells) {
            this.cells.add(ele);
        }
        return this;
    }

    public Occurrences withCells(Collection<Cell> cells) {
        this.setCells(cells);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLineRanges() != null) {
            sb.append("LineRanges: ").append(this.getLineRanges()).append(",");
        }
        if (this.getOffsetRanges() != null) {
            sb.append("OffsetRanges: ").append(this.getOffsetRanges()).append(",");
        }
        if (this.getPages() != null) {
            sb.append("Pages: ").append(this.getPages()).append(",");
        }
        if (this.getRecords() != null) {
            sb.append("Records: ").append(this.getRecords()).append(",");
        }
        if (this.getCells() != null) {
            sb.append("Cells: ").append(this.getCells());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Occurrences)) {
            return false;
        }
        Occurrences other = (Occurrences)obj;
        if (other.getLineRanges() == null ^ this.getLineRanges() == null) {
            return false;
        }
        if (other.getLineRanges() != null && !other.getLineRanges().equals(this.getLineRanges())) {
            return false;
        }
        if (other.getOffsetRanges() == null ^ this.getOffsetRanges() == null) {
            return false;
        }
        if (other.getOffsetRanges() != null && !other.getOffsetRanges().equals(this.getOffsetRanges())) {
            return false;
        }
        if (other.getPages() == null ^ this.getPages() == null) {
            return false;
        }
        if (other.getPages() != null && !other.getPages().equals(this.getPages())) {
            return false;
        }
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (other.getRecords() != null && !other.getRecords().equals(this.getRecords())) {
            return false;
        }
        if (other.getCells() == null ^ this.getCells() == null) {
            return false;
        }
        return other.getCells() == null || other.getCells().equals(this.getCells());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLineRanges() == null ? 0 : this.getLineRanges().hashCode());
        hashCode = 31 * hashCode + (this.getOffsetRanges() == null ? 0 : this.getOffsetRanges().hashCode());
        hashCode = 31 * hashCode + (this.getPages() == null ? 0 : this.getPages().hashCode());
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        hashCode = 31 * hashCode + (this.getCells() == null ? 0 : this.getCells().hashCode());
        return hashCode;
    }

    public Occurrences clone() {
        try {
            return (Occurrences)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OccurrencesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

