/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateStandardsControlAssociations"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchUpdateStandardsControlAssociationsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Updates the enablement status of a security control in a specified standard.
     * </p>
     */
    private java.util.List<StandardsControlAssociationUpdate> standardsControlAssociationUpdates;

    /**
     * <p>
     * Updates the enablement status of a security control in a specified standard.
     * </p>
     * 
     * @return Updates the enablement status of a security control in a specified standard.
     */

    public java.util.List<StandardsControlAssociationUpdate> getStandardsControlAssociationUpdates() {
        return standardsControlAssociationUpdates;
    }

    /**
     * <p>
     * Updates the enablement status of a security control in a specified standard.
     * </p>
     * 
     * @param standardsControlAssociationUpdates
     *        Updates the enablement status of a security control in a specified standard.
     */

    public void setStandardsControlAssociationUpdates(java.util.Collection<StandardsControlAssociationUpdate> standardsControlAssociationUpdates) {
        if (standardsControlAssociationUpdates == null) {
            this.standardsControlAssociationUpdates = null;
            return;
        }

        this.standardsControlAssociationUpdates = new java.util.ArrayList<StandardsControlAssociationUpdate>(standardsControlAssociationUpdates);
    }

    /**
     * <p>
     * Updates the enablement status of a security control in a specified standard.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setStandardsControlAssociationUpdates(java.util.Collection)} or
     * {@link #withStandardsControlAssociationUpdates(java.util.Collection)} if you want to override the existing
     * values.
     * </p>
     * 
     * @param standardsControlAssociationUpdates
     *        Updates the enablement status of a security control in a specified standard.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchUpdateStandardsControlAssociationsRequest withStandardsControlAssociationUpdates(
            StandardsControlAssociationUpdate... standardsControlAssociationUpdates) {
        if (this.standardsControlAssociationUpdates == null) {
            setStandardsControlAssociationUpdates(new java.util.ArrayList<StandardsControlAssociationUpdate>(standardsControlAssociationUpdates.length));
        }
        for (StandardsControlAssociationUpdate ele : standardsControlAssociationUpdates) {
            this.standardsControlAssociationUpdates.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Updates the enablement status of a security control in a specified standard.
     * </p>
     * 
     * @param standardsControlAssociationUpdates
     *        Updates the enablement status of a security control in a specified standard.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchUpdateStandardsControlAssociationsRequest withStandardsControlAssociationUpdates(
            java.util.Collection<StandardsControlAssociationUpdate> standardsControlAssociationUpdates) {
        setStandardsControlAssociationUpdates(standardsControlAssociationUpdates);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStandardsControlAssociationUpdates() != null)
            sb.append("StandardsControlAssociationUpdates: ").append(getStandardsControlAssociationUpdates());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchUpdateStandardsControlAssociationsRequest == false)
            return false;
        BatchUpdateStandardsControlAssociationsRequest other = (BatchUpdateStandardsControlAssociationsRequest) obj;
        if (other.getStandardsControlAssociationUpdates() == null ^ this.getStandardsControlAssociationUpdates() == null)
            return false;
        if (other.getStandardsControlAssociationUpdates() != null
                && other.getStandardsControlAssociationUpdates().equals(this.getStandardsControlAssociationUpdates()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStandardsControlAssociationUpdates() == null) ? 0 : getStandardsControlAssociationUpdates().hashCode());
        return hashCode;
    }

    @Override
    public BatchUpdateStandardsControlAssociationsRequest clone() {
        return (BatchUpdateStandardsControlAssociationsRequest) super.clone();
    }

}
