/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.FindingProviderSeverity;
import com.amazonaws.services.securityhub.model.RelatedFinding;
import com.amazonaws.services.securityhub.model.transform.FindingProviderFieldsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FindingProviderFields
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer confidence;
    private Integer criticality;
    private List<RelatedFinding> relatedFindings;
    private FindingProviderSeverity severity;
    private List<String> types;

    public void setConfidence(Integer confidence) {
        this.confidence = confidence;
    }

    public Integer getConfidence() {
        return this.confidence;
    }

    public FindingProviderFields withConfidence(Integer confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public void setCriticality(Integer criticality) {
        this.criticality = criticality;
    }

    public Integer getCriticality() {
        return this.criticality;
    }

    public FindingProviderFields withCriticality(Integer criticality) {
        this.setCriticality(criticality);
        return this;
    }

    public List<RelatedFinding> getRelatedFindings() {
        return this.relatedFindings;
    }

    public void setRelatedFindings(Collection<RelatedFinding> relatedFindings) {
        if (relatedFindings == null) {
            this.relatedFindings = null;
            return;
        }
        this.relatedFindings = new ArrayList<RelatedFinding>(relatedFindings);
    }

    public FindingProviderFields withRelatedFindings(RelatedFinding ... relatedFindings) {
        if (this.relatedFindings == null) {
            this.setRelatedFindings(new ArrayList<RelatedFinding>(relatedFindings.length));
        }
        for (RelatedFinding ele : relatedFindings) {
            this.relatedFindings.add(ele);
        }
        return this;
    }

    public FindingProviderFields withRelatedFindings(Collection<RelatedFinding> relatedFindings) {
        this.setRelatedFindings(relatedFindings);
        return this;
    }

    public void setSeverity(FindingProviderSeverity severity) {
        this.severity = severity;
    }

    public FindingProviderSeverity getSeverity() {
        return this.severity;
    }

    public FindingProviderFields withSeverity(FindingProviderSeverity severity) {
        this.setSeverity(severity);
        return this;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<String> types) {
        if (types == null) {
            this.types = null;
            return;
        }
        this.types = new ArrayList<String>(types);
    }

    public FindingProviderFields withTypes(String ... types) {
        if (this.types == null) {
            this.setTypes(new ArrayList<String>(types.length));
        }
        for (String ele : types) {
            this.types.add(ele);
        }
        return this;
    }

    public FindingProviderFields withTypes(Collection<String> types) {
        this.setTypes(types);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getCriticality() != null) {
            sb.append("Criticality: ").append(this.getCriticality()).append(",");
        }
        if (this.getRelatedFindings() != null) {
            sb.append("RelatedFindings: ").append(this.getRelatedFindings()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity()).append(",");
        }
        if (this.getTypes() != null) {
            sb.append("Types: ").append(this.getTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingProviderFields)) {
            return false;
        }
        FindingProviderFields other = (FindingProviderFields)obj;
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getCriticality() == null ^ this.getCriticality() == null) {
            return false;
        }
        if (other.getCriticality() != null && !other.getCriticality().equals(this.getCriticality())) {
            return false;
        }
        if (other.getRelatedFindings() == null ^ this.getRelatedFindings() == null) {
            return false;
        }
        if (other.getRelatedFindings() != null && !other.getRelatedFindings().equals(this.getRelatedFindings())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getTypes() == null ^ this.getTypes() == null) {
            return false;
        }
        return other.getTypes() == null || other.getTypes().equals(this.getTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getCriticality() == null ? 0 : this.getCriticality().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedFindings() == null ? 0 : this.getRelatedFindings().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getTypes() == null ? 0 : this.getTypes().hashCode());
        return hashCode;
    }

    public FindingProviderFields clone() {
        try {
            return (FindingProviderFields)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FindingProviderFieldsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

