/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An IPV6 CIDR block association.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Ipv6CidrBlockAssociation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Ipv6CidrBlockAssociation implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The association ID for the IPv6 CIDR block.
     * </p>
     */
    private String associationId;
    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     */
    private String ipv6CidrBlock;
    /**
     * <p>
     * Information about the state of the CIDR block. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>associating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>associated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failing</code>
     * </p>
     * </li>
     * </ul>
     */
    private String cidrBlockState;

    /**
     * <p>
     * The association ID for the IPv6 CIDR block.
     * </p>
     * 
     * @param associationId
     *        The association ID for the IPv6 CIDR block.
     */

    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    /**
     * <p>
     * The association ID for the IPv6 CIDR block.
     * </p>
     * 
     * @return The association ID for the IPv6 CIDR block.
     */

    public String getAssociationId() {
        return this.associationId;
    }

    /**
     * <p>
     * The association ID for the IPv6 CIDR block.
     * </p>
     * 
     * @param associationId
     *        The association ID for the IPv6 CIDR block.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Ipv6CidrBlockAssociation withAssociationId(String associationId) {
        setAssociationId(associationId);
        return this;
    }

    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     * 
     * @param ipv6CidrBlock
     *        The IPv6 CIDR block.
     */

    public void setIpv6CidrBlock(String ipv6CidrBlock) {
        this.ipv6CidrBlock = ipv6CidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     * 
     * @return The IPv6 CIDR block.
     */

    public String getIpv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     * 
     * @param ipv6CidrBlock
     *        The IPv6 CIDR block.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Ipv6CidrBlockAssociation withIpv6CidrBlock(String ipv6CidrBlock) {
        setIpv6CidrBlock(ipv6CidrBlock);
        return this;
    }

    /**
     * <p>
     * Information about the state of the CIDR block. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>associating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>associated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failing</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param cidrBlockState
     *        Information about the state of the CIDR block. Valid values are as follows:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>associating</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>associated</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>disassociating</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>disassociated</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>failed</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>failing</code>
     *        </p>
     *        </li>
     */

    public void setCidrBlockState(String cidrBlockState) {
        this.cidrBlockState = cidrBlockState;
    }

    /**
     * <p>
     * Information about the state of the CIDR block. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>associating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>associated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failing</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the state of the CIDR block. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>associating</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>associated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>disassociating</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>disassociated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failing</code>
     *         </p>
     *         </li>
     */

    public String getCidrBlockState() {
        return this.cidrBlockState;
    }

    /**
     * <p>
     * Information about the state of the CIDR block. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>associating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>associated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failing</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param cidrBlockState
     *        Information about the state of the CIDR block. Valid values are as follows:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>associating</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>associated</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>disassociating</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>disassociated</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>failed</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>failing</code>
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Ipv6CidrBlockAssociation withCidrBlockState(String cidrBlockState) {
        setCidrBlockState(cidrBlockState);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAssociationId() != null)
            sb.append("AssociationId: ").append(getAssociationId()).append(",");
        if (getIpv6CidrBlock() != null)
            sb.append("Ipv6CidrBlock: ").append(getIpv6CidrBlock()).append(",");
        if (getCidrBlockState() != null)
            sb.append("CidrBlockState: ").append(getCidrBlockState());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Ipv6CidrBlockAssociation == false)
            return false;
        Ipv6CidrBlockAssociation other = (Ipv6CidrBlockAssociation) obj;
        if (other.getAssociationId() == null ^ this.getAssociationId() == null)
            return false;
        if (other.getAssociationId() != null && other.getAssociationId().equals(this.getAssociationId()) == false)
            return false;
        if (other.getIpv6CidrBlock() == null ^ this.getIpv6CidrBlock() == null)
            return false;
        if (other.getIpv6CidrBlock() != null && other.getIpv6CidrBlock().equals(this.getIpv6CidrBlock()) == false)
            return false;
        if (other.getCidrBlockState() == null ^ this.getCidrBlockState() == null)
            return false;
        if (other.getCidrBlockState() != null && other.getCidrBlockState().equals(this.getCidrBlockState()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAssociationId() == null) ? 0 : getAssociationId().hashCode());
        hashCode = prime * hashCode + ((getIpv6CidrBlock() == null) ? 0 : getIpv6CidrBlock().hashCode());
        hashCode = prime * hashCode + ((getCidrBlockState() == null) ? 0 : getCidrBlockState().hashCode());
        return hashCode;
    }

    @Override
    public Ipv6CidrBlockAssociation clone() {
        try {
            return (Ipv6CidrBlockAssociation) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.Ipv6CidrBlockAssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
