/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateOrganizationConfigurationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Whether to automatically enable Security Hub for new accounts in the organization.
     * </p>
     * <p>
     * By default, this is <code>false</code>, and new accounts are not added automatically.
     * </p>
     * <p>
     * To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     * </p>
     */
    private Boolean autoEnable;
    /**
     * <p>
     * Whether to automatically enable Security Hub <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default
     * standards</a> for new member accounts in the organization.
     * </p>
     * <p>
     * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically enabled
     * with default Security Hub standards.
     * </p>
     * <p>
     * To opt out of enabling default standards for new member accounts, set this parameter equal to <code>NONE</code>.
     * </p>
     */
    private String autoEnableStandards;

    /**
     * <p>
     * Whether to automatically enable Security Hub for new accounts in the organization.
     * </p>
     * <p>
     * By default, this is <code>false</code>, and new accounts are not added automatically.
     * </p>
     * <p>
     * To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     * </p>
     * 
     * @param autoEnable
     *        Whether to automatically enable Security Hub for new accounts in the organization.</p>
     *        <p>
     *        By default, this is <code>false</code>, and new accounts are not added automatically.
     *        </p>
     *        <p>
     *        To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     */

    public void setAutoEnable(Boolean autoEnable) {
        this.autoEnable = autoEnable;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub for new accounts in the organization.
     * </p>
     * <p>
     * By default, this is <code>false</code>, and new accounts are not added automatically.
     * </p>
     * <p>
     * To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     * </p>
     * 
     * @return Whether to automatically enable Security Hub for new accounts in the organization.</p>
     *         <p>
     *         By default, this is <code>false</code>, and new accounts are not added automatically.
     *         </p>
     *         <p>
     *         To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     */

    public Boolean getAutoEnable() {
        return this.autoEnable;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub for new accounts in the organization.
     * </p>
     * <p>
     * By default, this is <code>false</code>, and new accounts are not added automatically.
     * </p>
     * <p>
     * To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     * </p>
     * 
     * @param autoEnable
     *        Whether to automatically enable Security Hub for new accounts in the organization.</p>
     *        <p>
     *        By default, this is <code>false</code>, and new accounts are not added automatically.
     *        </p>
     *        <p>
     *        To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateOrganizationConfigurationRequest withAutoEnable(Boolean autoEnable) {
        setAutoEnable(autoEnable);
        return this;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub for new accounts in the organization.
     * </p>
     * <p>
     * By default, this is <code>false</code>, and new accounts are not added automatically.
     * </p>
     * <p>
     * To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     * </p>
     * 
     * @return Whether to automatically enable Security Hub for new accounts in the organization.</p>
     *         <p>
     *         By default, this is <code>false</code>, and new accounts are not added automatically.
     *         </p>
     *         <p>
     *         To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     */

    public Boolean isAutoEnable() {
        return this.autoEnable;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default
     * standards</a> for new member accounts in the organization.
     * </p>
     * <p>
     * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically enabled
     * with default Security Hub standards.
     * </p>
     * <p>
     * To opt out of enabling default standards for new member accounts, set this parameter equal to <code>NONE</code>.
     * </p>
     * 
     * @param autoEnableStandards
     *        Whether to automatically enable Security Hub <a href=
     *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
     *        >default standards</a> for new member accounts in the organization.</p>
     *        <p>
     *        By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
     *        enabled with default Security Hub standards.
     *        </p>
     *        <p>
     *        To opt out of enabling default standards for new member accounts, set this parameter equal to
     *        <code>NONE</code>.
     * @see AutoEnableStandards
     */

    public void setAutoEnableStandards(String autoEnableStandards) {
        this.autoEnableStandards = autoEnableStandards;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default
     * standards</a> for new member accounts in the organization.
     * </p>
     * <p>
     * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically enabled
     * with default Security Hub standards.
     * </p>
     * <p>
     * To opt out of enabling default standards for new member accounts, set this parameter equal to <code>NONE</code>.
     * </p>
     * 
     * @return Whether to automatically enable Security Hub <a
     *         href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
     *         >default standards</a> for new member accounts in the organization.</p>
     *         <p>
     *         By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
     *         enabled with default Security Hub standards.
     *         </p>
     *         <p>
     *         To opt out of enabling default standards for new member accounts, set this parameter equal to
     *         <code>NONE</code>.
     * @see AutoEnableStandards
     */

    public String getAutoEnableStandards() {
        return this.autoEnableStandards;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default
     * standards</a> for new member accounts in the organization.
     * </p>
     * <p>
     * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically enabled
     * with default Security Hub standards.
     * </p>
     * <p>
     * To opt out of enabling default standards for new member accounts, set this parameter equal to <code>NONE</code>.
     * </p>
     * 
     * @param autoEnableStandards
     *        Whether to automatically enable Security Hub <a href=
     *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
     *        >default standards</a> for new member accounts in the organization.</p>
     *        <p>
     *        By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
     *        enabled with default Security Hub standards.
     *        </p>
     *        <p>
     *        To opt out of enabling default standards for new member accounts, set this parameter equal to
     *        <code>NONE</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AutoEnableStandards
     */

    public UpdateOrganizationConfigurationRequest withAutoEnableStandards(String autoEnableStandards) {
        setAutoEnableStandards(autoEnableStandards);
        return this;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default
     * standards</a> for new member accounts in the organization.
     * </p>
     * <p>
     * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically enabled
     * with default Security Hub standards.
     * </p>
     * <p>
     * To opt out of enabling default standards for new member accounts, set this parameter equal to <code>NONE</code>.
     * </p>
     * 
     * @param autoEnableStandards
     *        Whether to automatically enable Security Hub <a href=
     *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
     *        >default standards</a> for new member accounts in the organization.</p>
     *        <p>
     *        By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
     *        enabled with default Security Hub standards.
     *        </p>
     *        <p>
     *        To opt out of enabling default standards for new member accounts, set this parameter equal to
     *        <code>NONE</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AutoEnableStandards
     */

    public UpdateOrganizationConfigurationRequest withAutoEnableStandards(AutoEnableStandards autoEnableStandards) {
        this.autoEnableStandards = autoEnableStandards.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAutoEnable() != null)
            sb.append("AutoEnable: ").append(getAutoEnable()).append(",");
        if (getAutoEnableStandards() != null)
            sb.append("AutoEnableStandards: ").append(getAutoEnableStandards());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateOrganizationConfigurationRequest == false)
            return false;
        UpdateOrganizationConfigurationRequest other = (UpdateOrganizationConfigurationRequest) obj;
        if (other.getAutoEnable() == null ^ this.getAutoEnable() == null)
            return false;
        if (other.getAutoEnable() != null && other.getAutoEnable().equals(this.getAutoEnable()) == false)
            return false;
        if (other.getAutoEnableStandards() == null ^ this.getAutoEnableStandards() == null)
            return false;
        if (other.getAutoEnableStandards() != null && other.getAutoEnableStandards().equals(this.getAutoEnableStandards()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAutoEnable() == null) ? 0 : getAutoEnable().hashCode());
        hashCode = prime * hashCode + ((getAutoEnableStandards() == null) ? 0 : getAutoEnableStandards().hashCode());
        return hashCode;
    }

    @Override
    public UpdateOrganizationConfigurationRequest clone() {
        return (UpdateOrganizationConfigurationRequest) super.clone();
    }

}
