/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securityhub.model.ControlFindingGenerator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EnableSecurityHubRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, String> tags;
    private Boolean enableDefaultStandards;
    private String controlFindingGenerator;

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public EnableSecurityHubRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public EnableSecurityHubRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public EnableSecurityHubRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setEnableDefaultStandards(Boolean enableDefaultStandards) {
        this.enableDefaultStandards = enableDefaultStandards;
    }

    public Boolean getEnableDefaultStandards() {
        return this.enableDefaultStandards;
    }

    public EnableSecurityHubRequest withEnableDefaultStandards(Boolean enableDefaultStandards) {
        this.setEnableDefaultStandards(enableDefaultStandards);
        return this;
    }

    public Boolean isEnableDefaultStandards() {
        return this.enableDefaultStandards;
    }

    public void setControlFindingGenerator(String controlFindingGenerator) {
        this.controlFindingGenerator = controlFindingGenerator;
    }

    public String getControlFindingGenerator() {
        return this.controlFindingGenerator;
    }

    public EnableSecurityHubRequest withControlFindingGenerator(String controlFindingGenerator) {
        this.setControlFindingGenerator(controlFindingGenerator);
        return this;
    }

    public EnableSecurityHubRequest withControlFindingGenerator(ControlFindingGenerator controlFindingGenerator) {
        this.controlFindingGenerator = controlFindingGenerator.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEnableDefaultStandards() != null) {
            sb.append("EnableDefaultStandards: ").append(this.getEnableDefaultStandards()).append(",");
        }
        if (this.getControlFindingGenerator() != null) {
            sb.append("ControlFindingGenerator: ").append(this.getControlFindingGenerator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSecurityHubRequest)) {
            return false;
        }
        EnableSecurityHubRequest other = (EnableSecurityHubRequest)obj;
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEnableDefaultStandards() == null ^ this.getEnableDefaultStandards() == null) {
            return false;
        }
        if (other.getEnableDefaultStandards() != null && !other.getEnableDefaultStandards().equals(this.getEnableDefaultStandards())) {
            return false;
        }
        if (other.getControlFindingGenerator() == null ^ this.getControlFindingGenerator() == null) {
            return false;
        }
        return other.getControlFindingGenerator() == null || other.getControlFindingGenerator().equals(this.getControlFindingGenerator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEnableDefaultStandards() == null ? 0 : this.getEnableDefaultStandards().hashCode());
        hashCode = 31 * hashCode + (this.getControlFindingGenerator() == null ? 0 : this.getControlFindingGenerator().hashCode());
        return hashCode;
    }

    public EnableSecurityHubRequest clone() {
        return (EnableSecurityHubRequest)super.clone();
    }
}

