/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitylake.model.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDatalakeExceptionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Integer maxFailures;
    private String nextToken;
    private List<String> regionSet;

    public void setMaxFailures(Integer maxFailures) {
        this.maxFailures = maxFailures;
    }

    public Integer getMaxFailures() {
        return this.maxFailures;
    }

    public ListDatalakeExceptionsRequest withMaxFailures(Integer maxFailures) {
        this.setMaxFailures(maxFailures);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDatalakeExceptionsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getRegionSet() {
        return this.regionSet;
    }

    public void setRegionSet(Collection<String> regionSet) {
        if (regionSet == null) {
            this.regionSet = null;
            return;
        }
        this.regionSet = new ArrayList<String>(regionSet);
    }

    public ListDatalakeExceptionsRequest withRegionSet(String ... regionSet) {
        if (this.regionSet == null) {
            this.setRegionSet(new ArrayList<String>(regionSet.length));
        }
        for (String ele : regionSet) {
            this.regionSet.add(ele);
        }
        return this;
    }

    public ListDatalakeExceptionsRequest withRegionSet(Collection<String> regionSet) {
        this.setRegionSet(regionSet);
        return this;
    }

    public ListDatalakeExceptionsRequest withRegionSet(Region ... regionSet) {
        ArrayList<String> regionSetCopy = new ArrayList<String>(regionSet.length);
        for (Region value : regionSet) {
            regionSetCopy.add(value.toString());
        }
        if (this.getRegionSet() == null) {
            this.setRegionSet(regionSetCopy);
        } else {
            this.getRegionSet().addAll(regionSetCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMaxFailures() != null) {
            sb.append("MaxFailures: ").append(this.getMaxFailures()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRegionSet() != null) {
            sb.append("RegionSet: ").append(this.getRegionSet());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatalakeExceptionsRequest)) {
            return false;
        }
        ListDatalakeExceptionsRequest other = (ListDatalakeExceptionsRequest)obj;
        if (other.getMaxFailures() == null ^ this.getMaxFailures() == null) {
            return false;
        }
        if (other.getMaxFailures() != null && !other.getMaxFailures().equals(this.getMaxFailures())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRegionSet() == null ^ this.getRegionSet() == null) {
            return false;
        }
        return other.getRegionSet() == null || other.getRegionSet().equals(this.getRegionSet());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMaxFailures() == null ? 0 : this.getMaxFailures().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRegionSet() == null ? 0 : this.getRegionSet().hashCode());
        return hashCode;
    }

    public ListDatalakeExceptionsRequest clone() {
        return (ListDatalakeExceptionsRequest)super.clone();
    }
}

