/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.DataLakeLifecycleExpiration;
import com.amazonaws.services.securitylake.model.DataLakeLifecycleTransition;
import com.amazonaws.services.securitylake.model.transform.DataLakeLifecycleConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataLakeLifecycleConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private DataLakeLifecycleExpiration expiration;
    private List<DataLakeLifecycleTransition> transitions;

    public void setExpiration(DataLakeLifecycleExpiration expiration) {
        this.expiration = expiration;
    }

    public DataLakeLifecycleExpiration getExpiration() {
        return this.expiration;
    }

    public DataLakeLifecycleConfiguration withExpiration(DataLakeLifecycleExpiration expiration) {
        this.setExpiration(expiration);
        return this;
    }

    public List<DataLakeLifecycleTransition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Collection<DataLakeLifecycleTransition> transitions) {
        if (transitions == null) {
            this.transitions = null;
            return;
        }
        this.transitions = new ArrayList<DataLakeLifecycleTransition>(transitions);
    }

    public DataLakeLifecycleConfiguration withTransitions(DataLakeLifecycleTransition ... transitions) {
        if (this.transitions == null) {
            this.setTransitions(new ArrayList<DataLakeLifecycleTransition>(transitions.length));
        }
        for (DataLakeLifecycleTransition ele : transitions) {
            this.transitions.add(ele);
        }
        return this;
    }

    public DataLakeLifecycleConfiguration withTransitions(Collection<DataLakeLifecycleTransition> transitions) {
        this.setTransitions(transitions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpiration() != null) {
            sb.append("Expiration: ").append(this.getExpiration()).append(",");
        }
        if (this.getTransitions() != null) {
            sb.append("Transitions: ").append(this.getTransitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeLifecycleConfiguration)) {
            return false;
        }
        DataLakeLifecycleConfiguration other = (DataLakeLifecycleConfiguration)obj;
        if (other.getExpiration() == null ^ this.getExpiration() == null) {
            return false;
        }
        if (other.getExpiration() != null && !other.getExpiration().equals(this.getExpiration())) {
            return false;
        }
        if (other.getTransitions() == null ^ this.getTransitions() == null) {
            return false;
        }
        return other.getTransitions() == null || other.getTransitions().equals(this.getTransitions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpiration() == null ? 0 : this.getExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getTransitions() == null ? 0 : this.getTransitions().hashCode());
        return hashCode;
    }

    public DataLakeLifecycleConfiguration clone() {
        try {
            return (DataLakeLifecycleConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataLakeLifecycleConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

