/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securitylake.model.DataLakeSource;
import java.util.List;

@SdkInternalApi
public class DataLakeSourceMarshaller {
    private static final MarshallingInfo<String> ACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("account").build();
    private static final MarshallingInfo<List> EVENTCLASSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventClasses").build();
    private static final MarshallingInfo<String> SOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceName").build();
    private static final MarshallingInfo<List> SOURCESTATUSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceStatuses").build();
    private static final DataLakeSourceMarshaller instance = new DataLakeSourceMarshaller();

    public static DataLakeSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataLakeSource dataLakeSource, ProtocolMarshaller protocolMarshaller) {
        if (dataLakeSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataLakeSource.getAccount(), ACCOUNT_BINDING);
            protocolMarshaller.marshall(dataLakeSource.getEventClasses(), EVENTCLASSES_BINDING);
            protocolMarshaller.marshall((Object)dataLakeSource.getSourceName(), SOURCENAME_BINDING);
            protocolMarshaller.marshall(dataLakeSource.getSourceStatuses(), SOURCESTATUSES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

