/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.servermigration.model.Connector;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ConnectorMarshaller {
    private static final MarshallingInfo<String> CONNECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectorId").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<List> CAPABILITYLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("capabilityList").build();
    private static final MarshallingInfo<String> VMMANAGERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerName").build();
    private static final MarshallingInfo<String> VMMANAGERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerType").build();
    private static final MarshallingInfo<String> VMMANAGERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerId").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddress").build();
    private static final MarshallingInfo<String> MACADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("macAddress").build();
    private static final MarshallingInfo<Date> ASSOCIATEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("associatedOn").timestampFormat("unixTimestamp").build();
    private static final ConnectorMarshaller instance = new ConnectorMarshaller();

    public static ConnectorMarshaller getInstance() {
        return instance;
    }

    public void marshall(Connector connector, ProtocolMarshaller protocolMarshaller) {
        if (connector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)connector.getConnectorId(), CONNECTORID_BINDING);
            protocolMarshaller.marshall((Object)connector.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)connector.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(connector.getCapabilityList(), CAPABILITYLIST_BINDING);
            protocolMarshaller.marshall((Object)connector.getVmManagerName(), VMMANAGERNAME_BINDING);
            protocolMarshaller.marshall((Object)connector.getVmManagerType(), VMMANAGERTYPE_BINDING);
            protocolMarshaller.marshall((Object)connector.getVmManagerId(), VMMANAGERID_BINDING);
            protocolMarshaller.marshall((Object)connector.getIpAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)connector.getMacAddress(), MACADDRESS_BINDING);
            protocolMarshaller.marshall((Object)connector.getAssociatedOn(), ASSOCIATEDON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

