/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.DkimSigningAttributesOrigin;
import com.amazonaws.services.simpleemailv2.model.DkimSigningKeyLength;
import com.amazonaws.services.simpleemailv2.model.DkimStatus;
import com.amazonaws.services.simpleemailv2.model.transform.DkimAttributesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DkimAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean signingEnabled;
    private String status;
    private List<String> tokens;
    private String signingAttributesOrigin;
    private String nextSigningKeyLength;
    private String currentSigningKeyLength;
    private Date lastKeyGenerationTimestamp;

    public void setSigningEnabled(Boolean signingEnabled) {
        this.signingEnabled = signingEnabled;
    }

    public Boolean getSigningEnabled() {
        return this.signingEnabled;
    }

    public DkimAttributes withSigningEnabled(Boolean signingEnabled) {
        this.setSigningEnabled(signingEnabled);
        return this;
    }

    public Boolean isSigningEnabled() {
        return this.signingEnabled;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DkimAttributes withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public DkimAttributes withStatus(DkimStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public void setTokens(Collection<String> tokens) {
        if (tokens == null) {
            this.tokens = null;
            return;
        }
        this.tokens = new ArrayList<String>(tokens);
    }

    public DkimAttributes withTokens(String ... tokens) {
        if (this.tokens == null) {
            this.setTokens(new ArrayList<String>(tokens.length));
        }
        for (String ele : tokens) {
            this.tokens.add(ele);
        }
        return this;
    }

    public DkimAttributes withTokens(Collection<String> tokens) {
        this.setTokens(tokens);
        return this;
    }

    public void setSigningAttributesOrigin(String signingAttributesOrigin) {
        this.signingAttributesOrigin = signingAttributesOrigin;
    }

    public String getSigningAttributesOrigin() {
        return this.signingAttributesOrigin;
    }

    public DkimAttributes withSigningAttributesOrigin(String signingAttributesOrigin) {
        this.setSigningAttributesOrigin(signingAttributesOrigin);
        return this;
    }

    public DkimAttributes withSigningAttributesOrigin(DkimSigningAttributesOrigin signingAttributesOrigin) {
        this.signingAttributesOrigin = signingAttributesOrigin.toString();
        return this;
    }

    public void setNextSigningKeyLength(String nextSigningKeyLength) {
        this.nextSigningKeyLength = nextSigningKeyLength;
    }

    public String getNextSigningKeyLength() {
        return this.nextSigningKeyLength;
    }

    public DkimAttributes withNextSigningKeyLength(String nextSigningKeyLength) {
        this.setNextSigningKeyLength(nextSigningKeyLength);
        return this;
    }

    public DkimAttributes withNextSigningKeyLength(DkimSigningKeyLength nextSigningKeyLength) {
        this.nextSigningKeyLength = nextSigningKeyLength.toString();
        return this;
    }

    public void setCurrentSigningKeyLength(String currentSigningKeyLength) {
        this.currentSigningKeyLength = currentSigningKeyLength;
    }

    public String getCurrentSigningKeyLength() {
        return this.currentSigningKeyLength;
    }

    public DkimAttributes withCurrentSigningKeyLength(String currentSigningKeyLength) {
        this.setCurrentSigningKeyLength(currentSigningKeyLength);
        return this;
    }

    public DkimAttributes withCurrentSigningKeyLength(DkimSigningKeyLength currentSigningKeyLength) {
        this.currentSigningKeyLength = currentSigningKeyLength.toString();
        return this;
    }

    public void setLastKeyGenerationTimestamp(Date lastKeyGenerationTimestamp) {
        this.lastKeyGenerationTimestamp = lastKeyGenerationTimestamp;
    }

    public Date getLastKeyGenerationTimestamp() {
        return this.lastKeyGenerationTimestamp;
    }

    public DkimAttributes withLastKeyGenerationTimestamp(Date lastKeyGenerationTimestamp) {
        this.setLastKeyGenerationTimestamp(lastKeyGenerationTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSigningEnabled() != null) {
            sb.append("SigningEnabled: ").append(this.getSigningEnabled()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTokens() != null) {
            sb.append("Tokens: ").append(this.getTokens()).append(",");
        }
        if (this.getSigningAttributesOrigin() != null) {
            sb.append("SigningAttributesOrigin: ").append(this.getSigningAttributesOrigin()).append(",");
        }
        if (this.getNextSigningKeyLength() != null) {
            sb.append("NextSigningKeyLength: ").append(this.getNextSigningKeyLength()).append(",");
        }
        if (this.getCurrentSigningKeyLength() != null) {
            sb.append("CurrentSigningKeyLength: ").append(this.getCurrentSigningKeyLength()).append(",");
        }
        if (this.getLastKeyGenerationTimestamp() != null) {
            sb.append("LastKeyGenerationTimestamp: ").append(this.getLastKeyGenerationTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DkimAttributes)) {
            return false;
        }
        DkimAttributes other = (DkimAttributes)obj;
        if (other.getSigningEnabled() == null ^ this.getSigningEnabled() == null) {
            return false;
        }
        if (other.getSigningEnabled() != null && !other.getSigningEnabled().equals(this.getSigningEnabled())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTokens() == null ^ this.getTokens() == null) {
            return false;
        }
        if (other.getTokens() != null && !other.getTokens().equals(this.getTokens())) {
            return false;
        }
        if (other.getSigningAttributesOrigin() == null ^ this.getSigningAttributesOrigin() == null) {
            return false;
        }
        if (other.getSigningAttributesOrigin() != null && !other.getSigningAttributesOrigin().equals(this.getSigningAttributesOrigin())) {
            return false;
        }
        if (other.getNextSigningKeyLength() == null ^ this.getNextSigningKeyLength() == null) {
            return false;
        }
        if (other.getNextSigningKeyLength() != null && !other.getNextSigningKeyLength().equals(this.getNextSigningKeyLength())) {
            return false;
        }
        if (other.getCurrentSigningKeyLength() == null ^ this.getCurrentSigningKeyLength() == null) {
            return false;
        }
        if (other.getCurrentSigningKeyLength() != null && !other.getCurrentSigningKeyLength().equals(this.getCurrentSigningKeyLength())) {
            return false;
        }
        if (other.getLastKeyGenerationTimestamp() == null ^ this.getLastKeyGenerationTimestamp() == null) {
            return false;
        }
        return other.getLastKeyGenerationTimestamp() == null || other.getLastKeyGenerationTimestamp().equals(this.getLastKeyGenerationTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSigningEnabled() == null ? 0 : this.getSigningEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTokens() == null ? 0 : this.getTokens().hashCode());
        hashCode = 31 * hashCode + (this.getSigningAttributesOrigin() == null ? 0 : this.getSigningAttributesOrigin().hashCode());
        hashCode = 31 * hashCode + (this.getNextSigningKeyLength() == null ? 0 : this.getNextSigningKeyLength().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentSigningKeyLength() == null ? 0 : this.getCurrentSigningKeyLength().hashCode());
        hashCode = 31 * hashCode + (this.getLastKeyGenerationTimestamp() == null ? 0 : this.getLastKeyGenerationTimestamp().hashCode());
        return hashCode;
    }

    public DkimAttributes clone() {
        try {
            return (DkimAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DkimAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

